/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.key;

import io.github.astrapi69.crypt.data.factory.KeyAgreementFactory;
import io.github.astrapi69.crypt.data.model.SharedSecretModel;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SharedSecretDecryptor {
    final String provider;
    final String cipherAlgorithm;
    SecretKey secretKey;
    IvParameterSpec ivSpec;
    SharedSecretModel model;

    public SharedSecretDecryptor(SharedSecretModel model) {
        this(model.getPrivateKey(), model.getPublicKey(), model.getKeyAgreementAlgorithm(), model.getSecretKeyAlgorithm(), model.getProvider(), model.getCipherAlgorithm(), model.getIv());
        this.model = model;
    }

    public SharedSecretDecryptor(PrivateKey privateKey, PublicKey publicKey, String keyAgreementAlgorithm, String secretKeyAlgorithm, String provider, String cipherAlgorithm, byte[] iv) {
        this.ivSpec = new IvParameterSpec(iv);
        this.provider = provider;
        this.cipherAlgorithm = cipherAlgorithm;
        this.secretKey = (SecretKey)RuntimeExceptionDecorator.decorate(() -> KeyAgreementFactory.newSharedSecret((PrivateKey)privateKey, (PublicKey)publicKey, (String)keyAgreementAlgorithm, (String)secretKeyAlgorithm, (String)provider));
    }

    public byte[] decrypt(byte[] encrypted) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.secretKey.getEncoded(), this.secretKey.getAlgorithm());
        Cipher cipher = Cipher.getInstance(this.cipherAlgorithm, this.provider);
        cipher.init(2, (Key)secretKeySpec, this.ivSpec);
        byte[] decryptedData = new byte[cipher.getOutputSize(encrypted.length)];
        int decryptLength = cipher.update(encrypted, 0, encrypted.length, decryptedData, 0);
        cipher.doFinal(decryptedData, decryptLength);
        return decryptedData;
    }
}

