/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.key;

import io.github.astrapi69.crypt.data.factory.KeyAgreementFactory;
import io.github.astrapi69.crypt.data.model.SharedSecretModel;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class SharedSecretEncryptor {
    final String provider;
    final String cipherAlgorithm;
    SecretKey secretKey;
    IvParameterSpec ivSpec;
    SharedSecretModel model;

    public SharedSecretEncryptor(SharedSecretModel model) {
        this(model.getPrivateKey(), model.getPublicKey(), model.getKeyAgreementAlgorithm(), model.getSecretKeyAlgorithm(), model.getProvider(), model.getCipherAlgorithm(), model.getIv());
        this.model = model;
    }

    public SharedSecretEncryptor(PrivateKey privateKey, PublicKey publicKey, String keyAgreementAlgorithm, String secretKeyAlgorithm, String provider, String cipherAlgorithm, byte[] iv) {
        this.ivSpec = new IvParameterSpec(iv);
        this.provider = provider;
        this.cipherAlgorithm = cipherAlgorithm;
        this.secretKey = (SecretKey)RuntimeExceptionDecorator.decorate(() -> KeyAgreementFactory.newSharedSecret((PrivateKey)privateKey, (PublicKey)publicKey, (String)keyAgreementAlgorithm, (String)secretKeyAlgorithm, (String)provider));
    }

    public byte[] encrypt(byte[] toEncrypt) throws Exception {
        Cipher cipher = Cipher.getInstance(this.cipherAlgorithm, this.provider);
        cipher.init(1, (Key)this.secretKey, this.ivSpec);
        byte[] encryptedCryptData = new byte[cipher.getOutputSize(toEncrypt.length)];
        int encryptedLength = cipher.update(toEncrypt, 0, toEncrypt.length, encryptedCryptData, 0);
        cipher.doFinal(encryptedCryptData, encryptedLength);
        return encryptedCryptData;
    }
}

