/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.obfuscation.character;

import com.google.common.collect.BiMap;
import io.github.astrapi69.check.Check;
import io.github.astrapi69.crypt.api.obfuscation.Obfuscatable;
import io.github.astrapi69.crypt.data.obfuscation.rule.ObfuscationOperationRule;
import io.github.astrapi69.mystic.crypt.obfuscation.character.ObfuscatorExtensions;
import java.util.Objects;

public class CharacterObfuscator
implements Obfuscatable {
    private final String key;
    private final BiMap<Character, ObfuscationOperationRule<Character, Character>> rules;
    private boolean disentanglable;

    public CharacterObfuscator(BiMap<Character, ObfuscationOperationRule<Character, Character>> rules, String key) {
        this(rules, key, false);
    }

    public CharacterObfuscator(BiMap<Character, ObfuscationOperationRule<Character, Character>> rules, String key, boolean validate) {
        Objects.requireNonNull(rules);
        Objects.requireNonNull(key);
        Check.get().notEmpty(rules, "rules");
        Check.get().notEmpty((CharSequence)key, "key");
        this.rules = rules;
        this.key = key;
        if (validate) {
            this.disentanglable = ObfuscatorExtensions.validate(this.rules);
        }
    }

    public String disentangle() {
        return ObfuscatorExtensions.disentangle(this.rules, this.obfuscate());
    }

    public boolean isDisentanglable() {
        return this.disentanglable;
    }

    public String obfuscate() {
        return ObfuscatorExtensions.obfuscateWith(this.rules, this.key);
    }
}

