/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.obfuscation.simple;

import com.google.common.collect.BiMap;
import io.github.astrapi69.check.Check;
import io.github.astrapi69.crypt.api.obfuscation.Obfuscatable;
import io.github.astrapi69.crypt.data.obfuscation.rule.ObfuscationRule;
import io.github.astrapi69.mystic.crypt.obfuscation.simple.SimpleObfuscatorExtensions;
import java.util.Objects;

public class SimpleCharacterObfuscator
implements Obfuscatable {
    private final BiMap<Character, Character> biMap;
    private final String key;
    private final BiMap<Character, ObfuscationRule<Character, Character>> rules;

    public SimpleCharacterObfuscator(BiMap<Character, ObfuscationRule<Character, Character>> rules, String key) {
        Objects.requireNonNull(rules);
        Objects.requireNonNull(key);
        Check.get().notEmpty(rules, "rules");
        Check.get().notEmpty((CharSequence)key, "key");
        this.rules = rules;
        this.biMap = SimpleObfuscatorExtensions.toCharacterBiMap(rules);
        this.key = key;
    }

    public String disentangle() {
        String obfuscated = SimpleObfuscatorExtensions.obfuscateWith(this.rules, this.key);
        return this.disentangle(obfuscated);
    }

    public String disentangle(String obfuscated) {
        String disentangled = SimpleObfuscatorExtensions.disentangleBiMap(this.biMap, obfuscated);
        return disentangled;
    }

    public String obfuscate() {
        String obfuscated = SimpleObfuscatorExtensions.obfuscateWith(this.rules, this.key);
        return obfuscated;
    }
}

