/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.obfuscation.simple;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.github.astrapi69.crypt.data.obfuscation.rule.ObfuscationRule;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class SimpleObfuscatorExtensions {
    private SimpleObfuscatorExtensions() {
    }

    public static String disentangle(BiMap<Character, ObfuscationRule<Character, Character>> rules, String obfuscated) {
        boolean processed = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < obfuscated.length(); ++i) {
            char currentChar = obfuscated.charAt(i);
            Character currentCharacter = Character.valueOf(currentChar);
            for (Map.Entry entry : rules.entrySet()) {
                ObfuscationRule obfuscationRule = (ObfuscationRule)entry.getValue();
                Character replaceWith = (Character)obfuscationRule.getReplaceWith();
                Character character = (Character)obfuscationRule.getCharacter();
                if (!currentCharacter.equals(replaceWith) || !rules.containsKey((Object)replaceWith)) continue;
                sb.append(character);
                processed = true;
                break;
            }
            if (!processed) {
                sb.append(currentChar);
            }
            processed = false;
        }
        return sb.toString();
    }

    public static String disentangleBiMap(BiMap<Character, Character> rules, String obfuscated) {
        return SimpleObfuscatorExtensions.obfuscateBiMap((BiMap<Character, Character>)rules.inverse(), obfuscated);
    }

    public static String obfuscateBiMap(BiMap<Character, Character> rules, String toObfuscate) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toObfuscate.length(); ++i) {
            char currentChar = toObfuscate.charAt(i);
            Character currentCharacter = Character.valueOf(currentChar);
            if (rules.containsKey((Object)currentCharacter)) {
                sb.append(rules.get((Object)currentCharacter));
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    public static String obfuscateWith(BiMap<Character, ObfuscationRule<Character, Character>> rules, String toObfuscate) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toObfuscate.length(); ++i) {
            char currentCharacter = toObfuscate.charAt(i);
            Character asCharacter = Character.valueOf(currentCharacter);
            String charAsString = Character.toString(currentCharacter);
            if (rules.containsKey((Object)asCharacter)) {
                ObfuscationRule obfuscationOperationRule = (ObfuscationRule)rules.get((Object)asCharacter);
                Character replaceWith = (Character)obfuscationOperationRule.getReplaceWith();
                sb.append(replaceWith);
                continue;
            }
            sb.append(charAsString);
        }
        return sb.toString();
    }

    public static BiMap<Character, Character> toCharacterBiMap(BiMap<Character, ObfuscationRule<Character, Character>> rules) {
        Objects.requireNonNull(rules);
        HashBiMap biMap = HashBiMap.create();
        rules.keySet().stream().forEach(arg_0 -> SimpleObfuscatorExtensions.lambda$toCharacterBiMap$0((BiMap)biMap, rules, arg_0));
        return biMap;
    }

    public static boolean validate(BiMap<Character, ObfuscationRule<Character, Character>> rules) {
        Set keySet = rules.keySet();
        for (Map.Entry entry : rules.entrySet()) {
            ObfuscationRule value = (ObfuscationRule)entry.getValue();
            if (!keySet.contains(value.getReplaceWith())) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$toCharacterBiMap$0(BiMap biMap, BiMap rules, Character key) {
        biMap.put((Object)((Character)((ObfuscationRule)rules.get((Object)key)).getCharacter()), (Object)((Character)((ObfuscationRule)rules.get((Object)key)).getReplaceWith()));
    }
}

