/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.processor.bruteforce;

import io.github.astrapi69.crypt.data.key.reader.EncryptedPrivateKeyReader;
import io.github.astrapi69.crypt.data.key.reader.PrivateKeyReader;
import io.github.astrapi69.mystic.crypt.processor.bruteforce.BruteForceProcessor;
import java.io.File;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.Objects;
import java.util.Optional;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class PrivateKeyBruteForceProcessor {
    private PrivateKeyBruteForceProcessor() {
    }

    public static Optional<String> resolvePassword(File privateKeyFile, BruteForceProcessor processor) {
        Optional<String> optionalPassword;
        block5: {
            Objects.requireNonNull(processor);
            optionalPassword = Optional.empty();
            try {
                boolean isPasswordProtected = PrivateKeyReader.isPrivateKeyPasswordProtected((File)privateKeyFile);
                if (isPasswordProtected) break block5;
                String attempt = processor.getCurrentAttempt();
                Security.addProvider((Provider)new BouncyCastleProvider());
                while (true) {
                    try {
                        EncryptedPrivateKeyReader.getKeyPair((File)privateKeyFile, (String)attempt);
                        optionalPassword = Optional.of(attempt);
                    }
                    catch (IOException e) {
                        attempt = processor.getCurrentAttempt();
                        processor.increment();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ex) {
                return optionalPassword;
            }
        }
        return optionalPassword;
    }
}

