/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.processor.wordlist;

import io.github.astrapi69.check.Check;
import java.util.List;

public class WordlistsProcessor {
    private final List<String> words;
    private int currentIndex;
    private String toCheckAgainst;

    public WordlistsProcessor(List<String> words) {
        this.words = words;
        this.currentIndex = 0;
    }

    public WordlistsProcessor(List<String> words, String toCheckAgainst) {
        Check.get().notNull((Object)toCheckAgainst, "toCheckAgainst").notEmpty((CharSequence)toCheckAgainst, "toCheckAgainst");
        this.words = words;
        this.currentIndex = 0;
        this.toCheckAgainst = toCheckAgainst;
    }

    public String getCurrentAttempt() {
        if (this.currentIndex < this.words.size()) {
            String currentAttempt = this.words.get(this.currentIndex);
            return currentAttempt;
        }
        return null;
    }

    public String getToCheckAgainst() {
        return this.toCheckAgainst;
    }

    public void setToCheckAgainst(String toCheckAgainst) {
        this.toCheckAgainst = toCheckAgainst;
    }

    public boolean increment() {
        if (this.currentIndex == this.words.size()) {
            return false;
        }
        ++this.currentIndex;
        return true;
    }

    public boolean process() {
        boolean continueIterate = true;
        boolean found = false;
        String attempt = this.getCurrentAttempt();
        while (continueIterate) {
            if (attempt.equals(this.toCheckAgainst)) {
                found = true;
                break;
            }
            attempt = this.getCurrentAttempt();
            continueIterate = this.increment();
        }
        return found;
    }
}

