/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.pw;

import io.github.astrapi69.crypt.api.ByteArrayDecryptor;
import io.github.astrapi69.crypt.api.Cryptor;
import io.github.astrapi69.crypt.api.algorithm.compound.CompoundAlgorithm;
import io.github.astrapi69.crypt.data.factory.CipherFactory;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.Normalizer;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class PasswordByteDecryptor
implements ByteArrayDecryptor,
Cryptor {
    private Cipher cipher;
    private boolean initialized;
    private String normalizedPassword;

    public PasswordByteDecryptor(String password) {
        String normalizedPassword;
        Objects.requireNonNull(password);
        this.normalizedPassword = normalizedPassword = Normalizer.normalize(password, Normalizer.Form.NFC);
        RuntimeExceptionDecorator.decorate(() -> this.initialize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(byte[] encryptedBytes) throws Exception {
        byte[] decryptedBytes;
        Objects.requireNonNull(encryptedBytes);
        Cipher cipher = this.cipher;
        synchronized (cipher) {
            decryptedBytes = this.cipher.doFinal(encryptedBytes);
        }
        return decryptedBytes;
    }

    public synchronized void resetPassword() {
        this.normalizedPassword = null;
    }

    private synchronized void initialize() throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (!this.isInitialized()) {
            this.cipher = CipherFactory.newPBECipher((char[])this.normalizedPassword.toCharArray(), (int)this.newOperationMode(), (String)CompoundAlgorithm.PBE_WITH_MD5_AND_DES.getAlgorithm());
            this.resetPassword();
            this.initialized = true;
        }
    }

    private synchronized boolean isInitialized() {
        return this.initialized;
    }

    public int newOperationMode() {
        return 2;
    }
}

