/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.pw;

import io.github.astrapi69.crypt.api.ByteArrayEncryptor;
import io.github.astrapi69.crypt.api.Cryptor;
import io.github.astrapi69.crypt.api.algorithm.compound.CompoundAlgorithm;
import io.github.astrapi69.crypt.data.factory.CipherFactory;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.Normalizer;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class PasswordByteEncryptor
implements ByteArrayEncryptor,
Cryptor {
    private Cipher cipher;
    private boolean initialized;
    private String normalizedPassword;

    public PasswordByteEncryptor(String password) {
        String normalizedPassword;
        Objects.requireNonNull(password);
        this.normalizedPassword = normalizedPassword = Normalizer.normalize(password, Normalizer.Form.NFC);
        RuntimeExceptionDecorator.decorate(() -> this.initialize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(byte[] toEncrypt) throws Exception {
        byte[] encryptedBytes;
        Objects.requireNonNull(toEncrypt);
        Cipher cipher = this.cipher;
        synchronized (cipher) {
            encryptedBytes = this.cipher.doFinal(toEncrypt);
        }
        return encryptedBytes;
    }

    public synchronized void resetPassword() {
        this.normalizedPassword = null;
    }

    private synchronized void initialize() throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (!this.isInitialized()) {
            this.cipher = CipherFactory.newPBECipher((char[])this.normalizedPassword.toCharArray(), (int)this.newOperationMode(), (String)CompoundAlgorithm.PBE_WITH_MD5_AND_DES.getAlgorithm());
            this.resetPassword();
            this.initialized = true;
        }
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    public int newOperationMode() {
        return 1;
    }
}

