/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.pw;

import io.github.astrapi69.crypt.api.algorithm.HashAlgorithm;
import io.github.astrapi69.crypt.data.hash.HashExtensions;
import io.github.astrapi69.mystic.crypt.sha.Hasher;
import io.github.astrapi69.random.object.RandomObjectFactory;
import io.github.astrapi69.random.object.RandomWebObjectFactory;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Optional;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class PasswordEncryptor
implements Serializable {
    private static final PasswordEncryptor instance = new PasswordEncryptor();
    private static final long serialVersionUID = -4667877106378932018L;
    private final HashAlgorithm DEFAULT_ALGORITHM = HashAlgorithm.SHA_512;
    private final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    private PasswordEncryptor() {
    }

    public static PasswordEncryptor getInstance() {
        return instance;
    }

    public String getRandomPassword(int length) {
        return RandomWebObjectFactory.randomPassword((int)length);
    }

    public String getRandomPassword(Optional<Integer> length) {
        return RandomWebObjectFactory.randomPassword(length);
    }

    public String getRandomSalt() {
        return this.getRandomSalt(8);
    }

    public String getRandomSalt(int length) {
        return new String(RandomObjectFactory.randomSalt((int)length, (Charset)this.DEFAULT_CHARSET), this.DEFAULT_CHARSET);
    }

    public String hashAndHexPassword(String password, String salt) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException {
        return this.hashAndHexPassword(password, salt, this.DEFAULT_ALGORITHM, this.DEFAULT_CHARSET);
    }

    public String hashAndHexPassword(String password, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException {
        String hashedPassword = Hasher.hashAndHex(password, salt, hashAlgorithm, charset);
        return hashedPassword;
    }

    public String hashPassword(String password, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException {
        String hashedPassword = HashExtensions.hash((String)password, (String)salt, (HashAlgorithm)hashAlgorithm, (Charset)charset);
        return hashedPassword;
    }

    public boolean match(String hashedPassword, String dbHashedPassword) {
        return hashedPassword.equals(dbHashedPassword);
    }
}

