/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.pw;

import io.github.astrapi69.crypt.api.Cryptor;
import io.github.astrapi69.crypt.api.FileDecryptor;
import io.github.astrapi69.crypt.api.algorithm.compound.CompoundAlgorithm;
import io.github.astrapi69.crypt.data.factory.CipherFactory;
import io.github.astrapi69.mystic.crypt.io.CryptoCipherOutputStream;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.Normalizer;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.FilenameUtils;

public class PasswordFileDecryptor
implements FileDecryptor,
Cryptor {
    private Cipher cipher;
    private File decryptedFile;
    private boolean initialized;
    private String normalizedPassword;

    public PasswordFileDecryptor(String password, File decryptedFile) {
        String normalizedPassword;
        Objects.requireNonNull(password);
        this.decryptedFile = decryptedFile;
        this.normalizedPassword = normalizedPassword = Normalizer.normalize(password, Normalizer.Form.NFC);
        RuntimeExceptionDecorator.decorate(() -> this.initialize());
    }

    public File decrypt(File encrypted) throws Exception {
        Objects.requireNonNull(encrypted);
        if (this.decryptedFile == null) {
            String filename = FilenameUtils.getBaseName((String)encrypted.getName());
            this.decryptedFile = this.newDecryptedFile(encrypted.getParent(), filename + ".decrypted");
        }
        try (FileOutputStream decryptedOut = new FileOutputStream(this.decryptedFile);
             CryptoCipherOutputStream cos = new CryptoCipherOutputStream(decryptedOut, this.cipher);
             FileInputStream fileInputStream = new FileInputStream(encrypted);){
            int c;
            while ((c = ((InputStream)fileInputStream).read()) != -1) {
                cos.write(c);
            }
        }
        return this.decryptedFile;
    }

    public synchronized void resetPassword() {
        this.normalizedPassword = null;
    }

    private synchronized void initialize() throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (!this.isInitialized()) {
            this.cipher = CipherFactory.newPBECipher((char[])this.normalizedPassword.toCharArray(), (int)this.newOperationMode(), (String)CompoundAlgorithm.PBE_WITH_MD5_AND_DES.getAlgorithm());
            this.resetPassword();
            this.initialized = true;
        }
    }

    private synchronized boolean isInitialized() {
        return this.initialized;
    }

    public int newOperationMode() {
        return 2;
    }

    protected File newDecryptedFile(String parent, String child) {
        return new File(parent, child);
    }
}

