/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.pw;

import io.github.astrapi69.crypt.api.Cryptor;
import io.github.astrapi69.crypt.api.FileEncryptor;
import io.github.astrapi69.crypt.api.algorithm.compound.CompoundAlgorithm;
import io.github.astrapi69.crypt.data.factory.CipherFactory;
import io.github.astrapi69.mystic.crypt.io.CryptoCipherInputStream;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.Normalizer;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.FilenameUtils;

public class PasswordFileEncryptor
implements FileEncryptor,
Cryptor {
    private Cipher cipher;
    private File encryptedFile;
    private boolean initialized;
    private String normalizedPassword;

    public PasswordFileEncryptor(String password) {
        this(password, null);
    }

    public PasswordFileEncryptor(String password, File encryptedFile) {
        String normalizedPassword;
        Objects.requireNonNull(password);
        this.encryptedFile = encryptedFile;
        this.normalizedPassword = normalizedPassword = Normalizer.normalize(password, Normalizer.Form.NFC);
        RuntimeExceptionDecorator.decorate(() -> this.initialize());
    }

    public File encrypt(File toEncrypt) throws Exception {
        Objects.requireNonNull(toEncrypt);
        if (this.encryptedFile == null) {
            String filename = FilenameUtils.getBaseName((String)toEncrypt.getName());
            this.encryptedFile = this.newEncryptedFile(toEncrypt.getParent(), filename + ".enc");
        }
        try (CryptoCipherInputStream cis = new CryptoCipherInputStream(new FileInputStream(toEncrypt), this.cipher);
             FileOutputStream out = new FileOutputStream(this.encryptedFile);){
            int c;
            while ((c = cis.read()) != -1) {
                ((OutputStream)out).write(c);
            }
        }
        return this.encryptedFile;
    }

    public synchronized void resetPassword() {
        this.normalizedPassword = null;
    }

    private synchronized void initialize() throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (!this.isInitialized()) {
            this.cipher = CipherFactory.newPBECipher((char[])this.normalizedPassword.toCharArray(), (int)this.newOperationMode(), (String)CompoundAlgorithm.PBE_WITH_MD5_AND_DES.getAlgorithm());
            this.resetPassword();
            this.initialized = true;
        }
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    public int newOperationMode() {
        return 1;
    }

    protected File newEncryptedFile(String parent, String child) {
        return new File(parent, child);
    }
}

