/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.simple;

import io.github.astrapi69.crypt.api.Cryptor;
import io.github.astrapi69.crypt.api.StringEncryptor;
import io.github.astrapi69.crypt.api.algorithm.compound.CompoundAlgorithm;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class SimpleEncryptor
implements StringEncryptor,
Cryptor {
    private final String privateKey;
    private Cipher cipher;
    private boolean initialized;

    public SimpleEncryptor(String privateKey) {
        Objects.requireNonNull(privateKey);
        this.privateKey = privateKey;
    }

    public String encrypt(String string) throws UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        this.initialize();
        byte[] utf8 = string.getBytes(StandardCharsets.UTF_8.name());
        byte[] encrypt = this.cipher.doFinal(utf8);
        String encrypted = Base64.getEncoder().encodeToString(encrypt);
        return encrypted;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    private void initialize() throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (!this.isInitialized()) {
            PBEKeySpec keySpec = new PBEKeySpec(this.getPrivateKey().toCharArray());
            SecretKeyFactory factory = SecretKeyFactory.getInstance(CompoundAlgorithm.PBE_WITH_MD5_AND_DES.getAlgorithm());
            SecretKey key = factory.generateSecret(keySpec);
            this.cipher = Cipher.getInstance(key.getAlgorithm());
            PBEParameterSpec paramSpec = new PBEParameterSpec(CompoundAlgorithm.SALT, 19);
            this.cipher.init(this.newOperationMode(), (Key)key, paramSpec);
            this.initialized = true;
        }
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    public int newOperationMode() {
        return 1;
    }
}

