/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.ssl;

import io.github.astrapi69.crypt.data.factory.KeyStoreFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public final class KeyTrustExtensions {
    private KeyTrustExtensions() {
    }

    public static KeyManager[] resolveKeyManagers(String keystoreType, String password, File keystoreFile, String keyManagerAlgorithm) throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, KeyStoreException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStoreFactory.loadKeyStore((File)keystoreFile, (String)keystoreType, (String)password);
        KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(keyManagerAlgorithm);
        keyFactory.init(keyStore, password.toCharArray());
        KeyManager[] keyManagers = keyFactory.getKeyManagers();
        return keyManagers;
    }

    public static TrustManager[] resolveTrustManagers(String keystoreType, String password, File keystoreFile, String trustManagerAlgorithm) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException {
        KeyStore keyStore = KeyStoreFactory.loadKeyStore((File)keystoreFile, (String)keystoreType, (String)password);
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(trustManagerAlgorithm);
        trustFactory.init(keyStore);
        return trustFactory.getTrustManagers();
    }
}

