/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.mystic.crypt.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class KeystoreVerifier {
    public static boolean isKeystoreFile(String filePath, String password) {
        return KeystoreVerifier.isKeystoreFile(filePath, password.toCharArray());
    }

    public static boolean isKeystoreFile(String filePath, char[] password) {
        return KeystoreVerifier.isKeystoreFile(filePath, password, KeyStore.getDefaultType());
    }

    public static boolean isKeystoreFile(String filePath, String password, String type) {
        return KeystoreVerifier.isKeystoreFile(filePath, password.toCharArray(), type);
    }

    public static boolean isKeystoreFile(String filePath, char[] password, String type) {
        boolean bl;
        FileInputStream fis = new FileInputStream(filePath);
        try {
            KeyStore keystore = KeyStore.getInstance(type);
            keystore.load(fis, password);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                return false;
            }
        }
        fis.close();
        return bl;
    }

    public static boolean isKeystoreFile(String filePath, String password, String[] types) {
        return KeystoreVerifier.isKeystoreFile(filePath, password.toCharArray(), types);
    }

    public static boolean isKeystoreFile(String filePath, char[] password, String[] types) {
        for (String type : types) {
            if (!KeystoreVerifier.isKeystoreFile(filePath, password, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isKeystoreFile(File file, char[] password) {
        return KeystoreVerifier.isKeystoreFile(file.getAbsolutePath(), password);
    }

    public static boolean isKeystoreFile(File file, char[] password, String type) {
        return KeystoreVerifier.isKeystoreFile(file.getAbsolutePath(), password, type);
    }

    public static boolean isKeystoreFile(File file, String password, String type) {
        return KeystoreVerifier.isKeystoreFile(file.getAbsolutePath(), password.toCharArray(), type);
    }

    public static boolean isKeystoreFile(File file, String password) {
        return KeystoreVerifier.isKeystoreFile(file.getAbsolutePath(), password);
    }

    public static boolean isKeystoreFile(File file, String password, String[] types) {
        return KeystoreVerifier.isKeystoreFile(file.getAbsolutePath(), password, types);
    }

    public static boolean isKeystoreFile(File file, char[] password, String[] types) {
        return KeystoreVerifier.isKeystoreFile(file.getAbsolutePath(), password, types);
    }
}

