/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.net;

import io.github.astrapi69.net.socket.SocketExtensions;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class IPResolver {
    public static List<InetAddress> getAllClients(String netmask) throws IOException {
        ArrayList<InetAddress> availableIps = new ArrayList<InetAddress>();
        for (int i = 1; i <= 255; ++i) {
            InetAddress inetAddress = InetAddress.getByName(netmask + i);
            if (!inetAddress.isReachable(2000)) continue;
            availableIps.add(inetAddress);
        }
        return availableIps;
    }

    public static String getIP(InetAddress inetAddress) {
        String ip = "";
        ip = inetAddress.getHostAddress();
        if (ip.equals("")) {
            byte[] ipAddressInBytes = inetAddress.getAddress();
            for (int i = 0; i < ipAddressInBytes.length; ++i) {
                if (i > 0) {
                    ip = ip + ".";
                }
                ip = ip + (ipAddressInBytes[i] & 0xFF);
            }
        }
        return ip;
    }

    public static byte[] getIPAsByte(InetAddress inetAddress) {
        return inetAddress.getAddress();
    }

    public static String getLocalIP() throws UnknownHostException {
        return IPResolver.getIP(InetAddress.getLocalHost());
    }

    public static byte[] getLocalIPAsByte() throws UnknownHostException {
        return InetAddress.getLocalHost().getAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InetAddress getLocalIPFromServerSocket(int port, int backlog) throws UnknownHostException, IOException {
        InetAddress inetAddress = null;
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(port, backlog, InetAddress.getLocalHost());
            inetAddress = socket.getInetAddress();
            socket.close();
        }
        catch (Throwable throwable) {
            SocketExtensions.closeServerSocket(socket);
            throw throwable;
        }
        SocketExtensions.closeServerSocket(socket);
        return inetAddress;
    }

    public static String getLocalIPFromServerSocketAsString() throws UnknownHostException, IOException {
        InetAddress inetAddress = null;
        inetAddress = IPResolver.getLocalIPFromServerSocket(10000, 20000);
        return IPResolver.getIP(inetAddress);
    }

    public static String resolveIP(InetAddress inetAddress) {
        return IPResolver.getIP(inetAddress);
    }
}

