/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.net.proxy;

import java.net.Authenticator;
import java.net.PasswordAuthentication;

public class ProxyAuthenticator
extends Authenticator {
    private final String password;
    private final String user;

    public ProxyAuthenticator(String user, String password) {
        this.user = user;
        this.password = password;
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        return new PasswordAuthentication(this.user, this.password.toCharArray());
    }

    public static ProxyAuthenticatorBuilder builder() {
        return new ProxyAuthenticatorBuilder();
    }

    public ProxyAuthenticatorBuilder toBuilder() {
        return new ProxyAuthenticatorBuilder().password(this.password).user(this.user);
    }

    public String getPassword() {
        return this.password;
    }

    public String getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProxyAuthenticator)) {
            return false;
        }
        ProxyAuthenticator other = (ProxyAuthenticator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProxyAuthenticator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }

    public String toString() {
        return "ProxyAuthenticator(password=" + this.getPassword() + ", user=" + this.getUser() + ")";
    }

    public static class ProxyAuthenticatorBuilder {
        private String password;
        private String user;

        ProxyAuthenticatorBuilder() {
        }

        public ProxyAuthenticatorBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ProxyAuthenticatorBuilder user(String user) {
            this.user = user;
            return this;
        }

        public ProxyAuthenticator build() {
            return new ProxyAuthenticator(this.password, this.user);
        }

        public String toString() {
            return "ProxyAuthenticator.ProxyAuthenticatorBuilder(password=" + this.password + ", user=" + this.user + ")";
        }
    }
}

