/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.net.url;

import io.github.astrapi69.net.url.Protocol;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;

public class URLExtensions {
    public static String getFilename(URL url) throws UnsupportedEncodingException {
        if (URLExtensions.isJar(url) || URLExtensions.isEar(url)) {
            String fileName = URLDecoder.decode(url.getFile(), "UTF-8");
            fileName = fileName.substring(5, fileName.indexOf("!"));
            return fileName;
        }
        return URLDecoder.decode(url.getFile(), "UTF-8");
    }

    public static boolean isEar(URL url) {
        return url.getProtocol().equals(Protocol.EAR.getProtocol());
    }

    public static boolean isJar(URL url) {
        return url.getProtocol().equals(Protocol.JAR.getProtocol());
    }

    public static boolean isWar(URL url) {
        return url.getProtocol().equals(Protocol.WAR.getProtocol());
    }

    public static boolean isReachable(URL url) {
        try {
            URLConnection conn = url.openConnection();
            conn.connect();
            conn.getInputStream().close();
        }
        catch (MalformedURLException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

