/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.random;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Objects;

public final class SecureRandomBuilder {
    public static final String DEFAULT_ALGORITHM = "SHA1PRNG";
    private String algorithm;
    private String provider;
    private long seed = System.currentTimeMillis();

    private SecureRandomBuilder() {
    }

    public static SecureRandomBuilder getInstance() {
        return SecureRandomBuilder.newInstance();
    }

    public static SecureRandomBuilder getInstance(String algorithm) {
        return SecureRandomBuilder.newInstance().algorithm(algorithm);
    }

    public static SecureRandomBuilder getInstance(String algorithm, String provider) {
        return SecureRandomBuilder.newInstance().algorithm(algorithm).provider(provider);
    }

    public static SecureRandomBuilder getInstance(String algorithm, String provider, long seed) {
        return SecureRandomBuilder.newInstance().algorithm(algorithm).provider(provider).seed(seed);
    }

    public static SecureRandomBuilder getInstance(String algorithm, String provider, Date seed) {
        return SecureRandomBuilder.newInstance().algorithm(algorithm).provider(provider).seed(seed.getTime());
    }

    private static SecureRandomBuilder newInstance() {
        return new SecureRandomBuilder();
    }

    public SecureRandomBuilder algorithm(String algorithm) {
        Objects.requireNonNull(algorithm);
        this.algorithm = algorithm;
        return this;
    }

    public SecureRandom build() {
        SecureRandom secureRandom = null;
        if (this.algorithm != null && this.provider != null) {
            try {
                secureRandom = SecureRandom.getInstance(this.algorithm, this.provider);
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.algorithm != null) {
            try {
                secureRandom = SecureRandom.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        if (secureRandom == null) {
            try {
                secureRandom = SecureRandom.getInstance(DEFAULT_ALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        secureRandom.setSeed(this.seed);
        return secureRandom;
    }

    public SecureRandomBuilder provider(String provider) {
        Objects.requireNonNull(provider);
        this.provider = provider;
        return this;
    }

    public SecureRandomBuilder seed(long seed) {
        this.seed = seed;
        return this;
    }
}

