/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.random.date;

import io.github.astrapi69.date.CalculateDateExtensions;
import io.github.astrapi69.date.CreateDateExtensions;
import io.github.astrapi69.random.DefaultSecureRandom;
import io.github.astrapi69.random.SecureRandomFactory;
import io.github.astrapi69.random.enumeration.RandomAlgorithm;
import io.github.astrapi69.random.number.RandomBooleanFactory;
import io.github.astrapi69.random.number.RandomIntFactory;
import io.github.astrapi69.random.number.RandomLongFactory;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;

public final class RandomDateFactory {
    private RandomDateFactory() {
    }

    public static Date randomBirthday() {
        Date now = CreateDateExtensions.now();
        Date past = RandomDateFactory.randomDateBefore(now, 20000);
        Date recentlyPast = RandomDateFactory.randomDateBefore(now, 3000);
        return RandomDateFactory.randomBirthday(recentlyPast, past);
    }

    public static Date randomBirthday(Date from, Date till) {
        return RandomDateFactory.randomDatebetween(from, till);
    }

    public static Date randomDateAfter(Date date) {
        return RandomDateFactory.randomDateAfter(date, RandomIntFactory.randomInt(10000));
    }

    public static Date randomDateAfter(Date date, int range) {
        return RandomDateFactory.randomDateAfter(date, range, DefaultSecureRandom.get());
    }

    public static Date randomDateAfter(Date date, int range, SecureRandom secureRandom) {
        return CalculateDateExtensions.addDays((Date)date, (int)RandomIntFactory.randomInt(range, RandomAlgorithm.SECURE_RANDOM, secureRandom));
    }

    public static Date randomDateBefore(Date date) {
        return RandomDateFactory.randomDateBefore(date, 10000);
    }

    public static Date randomDateBefore(Date date, int range) {
        return RandomDateFactory.randomDateBefore(date, range, SecureRandomFactory.newSecureRandom());
    }

    public static Date randomDateBefore(Date date, int range, SecureRandom secureRandom) {
        return CalculateDateExtensions.substractDaysFromDate((Date)date, (int)RandomIntFactory.randomInt(range, RandomAlgorithm.SECURE_RANDOM, secureRandom));
    }

    public static Date randomDate() {
        return RandomDateFactory.randomDate(SecureRandomFactory.newSecureRandom());
    }

    public static Date randomDate(Date from) {
        return RandomDateFactory.randomDate(from, SecureRandomFactory.newSecureRandom());
    }

    public static Date randomDate(Date from, SecureRandom secureRandom) {
        Objects.requireNonNull(secureRandom);
        double randDouble = -secureRandom.nextDouble() * (double)from.getTime();
        double randomDouble = (double)from.getTime() - secureRandom.nextDouble();
        double result = randDouble / 99999.0 * (randomDouble / 99999.0);
        return new Date((long)result);
    }

    public static Date randomDate(SecureRandom secureRandom) {
        Date now = CreateDateExtensions.now();
        if (RandomBooleanFactory.randomBoolean(secureRandom)) {
            return RandomDateFactory.randomDateAfter(now, 10000, secureRandom);
        }
        return RandomDateFactory.randomDateBefore(now, 10000, secureRandom);
    }

    public static Date randomDateBetween(Date start, Date end, SecureRandom secureRandom) {
        Objects.requireNonNull(secureRandom);
        long randomLong = (long)((double)start.getTime() + secureRandom.nextDouble() * (double)(end.getTime() - start.getTime()));
        return new Date(randomLong);
    }

    public static String randomDateBetween(long startDate, long endDate, String format, SecureRandom secureRandom) {
        Objects.requireNonNull(secureRandom);
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        long randomLongBetween = RandomLongFactory.randomLongBetween(startDate, endDate, secureRandom);
        Date between = new Date(randomLongBetween);
        return sdf.format(between);
    }

    public static Date randomDatebetween(Date start, Date end) {
        return RandomDateFactory.randomDateBetween(start, end, SecureRandomFactory.newSecureRandom());
    }

    public static String randomDatebetween(long startDate, long endDate) {
        return RandomDateFactory.randomDatebetween(startDate, endDate, "dd.MM.yyyy HH:mm:ss");
    }

    public static String randomDatebetween(long startDate, long endDate, String format) {
        return RandomDateFactory.randomDateBetween(startDate, endDate, format, SecureRandomFactory.newSecureRandom());
    }

    public static Date randomDateBetween(Date from, int startDays, int endDays) {
        return RandomDateFactory.randomDateAfter(from, RandomIntFactory.randomIntBetween(startDays, endDays));
    }

    public static LocalDate randomLocalDate() {
        LocalDate now = LocalDate.now();
        LocalDate randomLocalDate = RandomBooleanFactory.randomBoolean() ? now.plusDays(RandomLongFactory.randomLongBetween(-999999999L, 999999999L)) : now.minusDays(RandomLongFactory.randomLongBetween(-999999999L, 999999999L));
        return randomLocalDate;
    }

    public static LocalDateTime randomLocalDateTime() {
        return LocalDateTime.of(RandomDateFactory.randomLocalDate(), RandomDateFactory.randomLocalTime());
    }

    public static LocalTime randomLocalTime() {
        LocalTime now = LocalTime.now();
        LocalTime randomLocalTime = RandomBooleanFactory.randomBoolean() ? now.plusHours(RandomLongFactory.randomLong(23L)).plusMinutes(RandomLongFactory.randomLong(59L)).plusSeconds(RandomLongFactory.randomLong(59L)) : now.minusHours(RandomLongFactory.randomLong(23L)).minusMinutes(RandomLongFactory.randomLong(59L)).minusSeconds(RandomLongFactory.randomLong(59L));
        return randomLocalTime;
    }

    public static ZoneId randomZoneId() {
        ArrayList<String> availableZoneIds = new ArrayList<String>(ZoneId.getAvailableZoneIds());
        return ZoneId.of((String)availableZoneIds.get(RandomIntFactory.randomInt(availableZoneIds.size())));
    }
}

