/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.random.number;

import io.github.astrapi69.random.DefaultSecureRandom;
import io.github.astrapi69.random.number.RandomIntFactory;
import java.math.BigInteger;
import java.security.SecureRandom;

public final class RandomBigIntegerFactory {
    private RandomBigIntegerFactory() {
    }

    public static BigInteger randomBigInteger() {
        return RandomBigIntegerFactory.randomBigInteger(DefaultSecureRandom.get());
    }

    public static BigInteger randomBigInteger(SecureRandom secureRandom) {
        return new BigInteger(RandomIntFactory.randomInt(180), secureRandom);
    }

    public static BigInteger randomSerialNumber() {
        return RandomBigIntegerFactory.randomSerialNumber(DefaultSecureRandom.get());
    }

    public static BigInteger randomSerialNumber(SecureRandom secureRandom) {
        long next = secureRandom.nextLong();
        if (next < 0L) {
            next *= -1L;
        }
        BigInteger serialNumber = BigInteger.valueOf(next);
        return serialNumber;
    }
}

