/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.random.number;

import io.github.astrapi69.math.MathExtensions;
import io.github.astrapi69.random.DefaultSecureRandom;
import io.github.astrapi69.random.SecureRandomFactory;
import io.github.astrapi69.random.enumeration.RandomAlgorithm;
import io.github.astrapi69.random.number.RandomNumberExtensions;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;

public final class RandomFloatFactory {
    private RandomFloatFactory() {
    }

    public static float randomFloat(float range, RandomAlgorithm algorithm, SecureRandom secureRandom) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(secureRandom);
        switch (algorithm) {
            case MATH_ABS: {
                return (float)(Math.abs(secureRandom.nextDouble()) % (double)range);
            }
            case MATH_RANDOM: {
                return (float)(Math.random() * (double)range);
            }
            case RANDOM: {
                float random = (float)new Random(System.currentTimeMillis()).nextDouble() % range;
                return MathExtensions.isPositive((float)random) ? random : random * -1.0f;
            }
        }
        return (float)(secureRandom.nextDouble() * (double)range);
    }

    public static float randomFloat(float range, SecureRandom secureRandom) {
        return RandomFloatFactory.randomFloat(range, RandomAlgorithm.SECURE_RANDOM, secureRandom);
    }

    public static float randomFloat(SecureRandom secureRandom) {
        return Objects.requireNonNull(secureRandom).nextFloat();
    }

    public static float randomFloat() {
        return RandomFloatFactory.randomFloat(DefaultSecureRandom.get());
    }

    public static float randomFloat(float range) {
        return RandomFloatFactory.randomFloat(range, RandomAlgorithm.SECURE_RANDOM);
    }

    public static float randomFloat(float range, RandomAlgorithm algorithm) {
        return RandomFloatFactory.randomFloat(range, Objects.requireNonNull(algorithm), DefaultSecureRandom.get());
    }

    public static float randomFloat(int afterComma, int beforeComma) {
        return Float.parseFloat(RandomNumberExtensions.getRandomNumberString(afterComma, beforeComma));
    }

    public static float randomFloatBetween(float start, float end) {
        return RandomFloatFactory.randomFloatBetween(start, end, SecureRandomFactory.newSecureRandom());
    }

    public static float randomFloatBetween(float start, float end, SecureRandom secureRandom) {
        return start + RandomFloatFactory.randomFloat(end - start, RandomAlgorithm.SECURE_RANDOM, Objects.requireNonNull(secureRandom));
    }
}

