/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.random.number;

import io.github.astrapi69.math.MathExtensions;
import io.github.astrapi69.random.RandomCharacters;
import io.github.astrapi69.random.number.RandomIntFactory;
import io.github.astrapi69.random.object.RandomStringFactory;

public final class RandomNumberExtensions {
    private RandomNumberExtensions() {
    }

    public static String getRandomNumberString(int afterComma, int beforeComma) {
        String decimals = RandomNumberExtensions.getRandomNumericString(afterComma);
        String preDecimals = RandomNumberExtensions.getRandomNumericString(beforeComma);
        String randomNumberString = decimals + "." + preDecimals;
        return randomNumberString;
    }

    public static String getRandomNumericString() {
        int maxLength = Math.min(RandomIntFactory.randomInt(1000), 1024);
        StringBuilder sb = new StringBuilder(maxLength);
        for (int i = 0; i < maxLength; ++i) {
            int randomInt = RandomIntFactory.randomInt();
            if (MathExtensions.isNegative((int)randomInt)) {
                sb.append(randomInt * -1);
                continue;
            }
            sb.append(randomInt);
        }
        return sb.toString();
    }

    public static String getRandomNumericString(int length) {
        String randomNumber = RandomStringFactory.newRandomString(RandomCharacters.numbers.getCharacters(), length);
        return randomNumber;
    }
}

