/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.random;

public final class SecureRandomBean {
    public static final String DEFAULT_ALGORITHM = "SHA1PRNG";
    public static final String DEFAULT_PROVIDER = "SUN";
    private final String algorithm;
    private final String provider;
    private final long seed;

    public SecureRandomBean() {
        this(DEFAULT_ALGORITHM, DEFAULT_PROVIDER, System.currentTimeMillis());
    }

    public SecureRandomBean(String algorithm, String provider, long seed) {
        this.algorithm = algorithm;
        this.provider = provider;
        this.seed = seed;
    }

    public static SecureRandomBeanBuilder builder() {
        return new SecureRandomBeanBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecureRandomBean)) {
            return false;
        }
        SecureRandomBean other = (SecureRandomBean)o;
        String this$algorithm = this.getAlgorithm();
        String other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
            return false;
        }
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        return this.getSeed() == other.getSeed();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getProvider() {
        return this.provider;
    }

    public long getSeed() {
        return this.seed;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        return result;
    }

    public SecureRandomBeanBuilder toBuilder() {
        return new SecureRandomBeanBuilder().algorithm(this.algorithm).provider(this.provider).seed(this.seed);
    }

    public String toString() {
        return "SecureRandomBean(algorithm=" + this.getAlgorithm() + ", provider=" + this.getProvider() + ", seed=" + this.getSeed() + ")";
    }

    public static class SecureRandomBeanBuilder {
        private String algorithm;
        private String provider;
        private long seed;

        SecureRandomBeanBuilder() {
        }

        public SecureRandomBeanBuilder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public SecureRandomBean build() {
            return new SecureRandomBean(this.algorithm, this.provider, this.seed);
        }

        public SecureRandomBeanBuilder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public SecureRandomBeanBuilder seed(long seed) {
            this.seed = seed;
            return this;
        }

        public String toString() {
            return "SecureRandomBean.SecureRandomBeanBuilder(algorithm=" + this.algorithm + ", provider=" + this.provider + ", seed=" + this.seed + ")";
        }
    }
}

