/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.random.address;

import io.github.astrapi69.random.number.RandomIntFactory;
import io.github.astrapi69.random.util.PropertiesLoader;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;

public final class RandomAddressExtensions {
    public static final String PROP_FILE_STREETS = "/resources/germanstreets.properties";
    public static final String PROP_FILE_ZIP_CITIES = "/resources/de_zip_city.properties";

    private RandomAddressExtensions() {
    }

    public static String getRandomStreet(Properties properties) throws IOException {
        Properties p = properties != null ? properties : PropertiesLoader.loadProperties(PROP_FILE_STREETS);
        int size = p.size();
        Object[] keys = p.keySet().toArray();
        String street = (String)p.get(keys[RandomIntFactory.randomInt(size)]);
        return street;
    }

    public static String getRandomStreetWithNumber(Properties properties) throws IOException {
        String street = RandomAddressExtensions.getRandomStreet(properties);
        String streetWithNumber = street + " " + RandomIntFactory.randomInt(200);
        return streetWithNumber;
    }

    public static String getRandomZip(Properties properties) {
        Set<Object> keyset = properties.keySet();
        Object[] keys = keyset.toArray();
        int randomIndex = RandomIntFactory.randomInt(keys.length);
        String zip = (String)keys[randomIndex];
        return zip;
    }
}

