/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.random.number;

import io.github.astrapi69.random.DefaultSecureRandom;
import io.github.astrapi69.random.enumeration.RandomAlgorithm;
import io.github.astrapi69.random.number.RandomBooleanFactory;
import io.github.astrapi69.random.number.RandomIntFactory;
import java.security.SecureRandom;
import java.util.Objects;

public final class RandomByteFactory {
    private RandomByteFactory() {
    }

    public static byte randomByte() {
        return RandomByteFactory.randomByte(DefaultSecureRandom.get());
    }

    public static byte randomByte(SecureRandom secureRandom) {
        return (byte)RandomIntFactory.randomInt(255, RandomAlgorithm.SECURE_RANDOM, Objects.requireNonNull(secureRandom));
    }

    public static byte[] randomByteArray(int length) {
        return RandomByteFactory.randomByteArray(length, DefaultSecureRandom.get());
    }

    public static byte[] randomByteArray(int length, SecureRandom secureRandom) {
        Objects.requireNonNull(secureRandom);
        byte[] randomByteArray = new byte[length];
        byte[] randomByteBox = new byte[1];
        for (int i = 0; i < length; ++i) {
            if (RandomBooleanFactory.randomBoolean(secureRandom)) {
                randomByteArray[i] = RandomByteFactory.randomByte(secureRandom);
                continue;
            }
            secureRandom.nextBytes(randomByteBox);
            randomByteArray[i] = randomByteBox[0];
        }
        return randomByteArray;
    }
}

