/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.random.number;

import io.github.astrapi69.math.MathExtensions;
import io.github.astrapi69.random.DefaultSecureRandom;
import io.github.astrapi69.random.enumeration.RandomAlgorithm;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;

public final class RandomDoubleFactory {
    private RandomDoubleFactory() {
    }

    public static double randomDouble(double range, RandomAlgorithm algorithm) {
        return RandomDoubleFactory.randomDouble(range, Objects.requireNonNull(algorithm), DefaultSecureRandom.get());
    }

    public static double randomDouble(double range, RandomAlgorithm algorithm, SecureRandom secureRandom) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(secureRandom);
        switch (algorithm) {
            case MATH_ABS: {
                return Math.abs(secureRandom.nextDouble()) % range;
            }
            case MATH_RANDOM: {
                return Math.random() * range;
            }
            case RANDOM: {
                double random = new Random(System.currentTimeMillis()).nextDouble() % range;
                return MathExtensions.isPositive((double)random) ? random : random * -1.0;
            }
        }
        return secureRandom.nextDouble() * range;
    }

    public static double randomDouble(double range, SecureRandom secureRandom) {
        return RandomDoubleFactory.randomDouble(range, RandomAlgorithm.SECURE_RANDOM, secureRandom);
    }

    public static double randomDouble(SecureRandom secureRandom) {
        return Objects.requireNonNull(secureRandom).nextDouble();
    }

    public static double randomDouble(double range) {
        return RandomDoubleFactory.randomDouble(range, DefaultSecureRandom.get());
    }

    public static double randomDouble() {
        return RandomDoubleFactory.randomDouble(Double.MAX_VALUE);
    }

    public static double randomDoubleBetween(double start, double end, SecureRandom secureRandom) {
        return start + RandomDoubleFactory.randomDouble(end - start, RandomAlgorithm.SECURE_RANDOM, Objects.requireNonNull(secureRandom));
    }

    public static double randomDoubleBetween(double start, double end) {
        return RandomDoubleFactory.randomDoubleBetween(start, end, DefaultSecureRandom.get());
    }
}

