/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.random.number;

import io.github.astrapi69.math.MathExtensions;
import io.github.astrapi69.random.DefaultSecureRandom;
import io.github.astrapi69.random.enumeration.RandomAlgorithm;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;

public final class RandomIntFactory {
    private RandomIntFactory() {
    }

    public static int randomInt(int range, RandomAlgorithm algorithm) {
        return RandomIntFactory.randomInt(range, Objects.requireNonNull(algorithm), DefaultSecureRandom.get());
    }

    public static int randomInt(int range, RandomAlgorithm algorithm, SecureRandom secureRandom) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(secureRandom);
        switch (algorithm) {
            case MATH_ABS: {
                return Math.abs(secureRandom.nextInt()) % range;
            }
            case MATH_RANDOM: {
                return (int)(Math.random() * (double)range);
            }
            case RANDOM: {
                int random = new Random(System.currentTimeMillis()).nextInt() % range;
                return MathExtensions.isPositive((int)random) ? random : random * -1;
            }
        }
        return (int)(secureRandom.nextDouble() * (double)range);
    }

    public static int randomInt(int range, SecureRandom secureRandom) {
        return RandomIntFactory.randomInt(range, RandomAlgorithm.SECURE_RANDOM, secureRandom);
    }

    public static int randomInt(SecureRandom secureRandom) {
        return Objects.requireNonNull(secureRandom).nextInt();
    }

    public static int randomInt() {
        return RandomIntFactory.randomInt(DefaultSecureRandom.get());
    }

    public static int randomInt(int range) {
        return RandomIntFactory.randomInt(range, DefaultSecureRandom.get());
    }

    public static int randomIntBetween(int minVolume, int maxVolume, SecureRandom secureRandom) {
        return minVolume + RandomIntFactory.randomInt(maxVolume - minVolume, RandomAlgorithm.SECURE_RANDOM, Objects.requireNonNull(secureRandom));
    }

    public static int randomIntBetween(int start, int end, boolean includeMin, boolean includeMax, SecureRandom secureRandom) {
        int randomIntBetween = start + RandomIntFactory.randomInt(end - (start - 1), secureRandom);
        if (includeMin && !includeMax) {
            randomIntBetween = start + RandomIntFactory.randomInt(end - start, secureRandom);
        }
        if (!includeMin && includeMax && randomIntBetween == start) {
            ++randomIntBetween;
        }
        if (!includeMin && !includeMax) {
            randomIntBetween = start + 1 + RandomIntFactory.randomInt(end - (start + 1), secureRandom);
        }
        return randomIntBetween;
    }

    public static int randomIntBetween(int start, int end) {
        return RandomIntFactory.randomIntBetween(start, end, true, false);
    }

    public static int randomIntBetween(int start, int end, boolean includeMin, boolean includeMax) {
        return RandomIntFactory.randomIntBetween(start, end, includeMin, includeMax, DefaultSecureRandom.get());
    }
}

