/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.random.number;

import io.github.astrapi69.math.MathExtensions;
import io.github.astrapi69.random.DefaultSecureRandom;
import io.github.astrapi69.random.SecureRandomFactory;
import io.github.astrapi69.random.enumeration.RandomAlgorithm;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;

public final class RandomLongFactory {
    private RandomLongFactory() {
    }

    public static long randomLong() {
        return RandomLongFactory.randomLong(DefaultSecureRandom.get());
    }

    public static long randomLong(long range) {
        return RandomLongFactory.randomLong(range, RandomAlgorithm.SECURE_RANDOM);
    }

    public static long randomLong(long range, RandomAlgorithm algorithm) {
        return RandomLongFactory.randomLong(range, Objects.requireNonNull(algorithm), DefaultSecureRandom.get());
    }

    public static long randomLongBetween(long start, long end) {
        return RandomLongFactory.randomLongBetween(start, end, SecureRandomFactory.newSecureRandom());
    }

    public static long randomLong(long range, RandomAlgorithm algorithm, SecureRandom secureRandom) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(secureRandom);
        switch (algorithm) {
            case MATH_ABS: {
                return (long)(Math.abs(secureRandom.nextDouble()) % (double)range);
            }
            case MATH_RANDOM: {
                return (long)(Math.random() * (double)range);
            }
            case RANDOM: {
                long random = (long)new Random(System.currentTimeMillis()).nextDouble() % range;
                return MathExtensions.isPositive((long)random) ? random : random * -1L;
            }
        }
        return (long)(secureRandom.nextDouble() * (double)range);
    }

    public static long randomLong(long range, SecureRandom secureRandom) {
        return RandomLongFactory.randomLong(range, RandomAlgorithm.SECURE_RANDOM, secureRandom);
    }

    public static long randomLong(SecureRandom secureRandom) {
        return RandomLongFactory.randomLong(Objects.requireNonNull(secureRandom).nextLong());
    }

    public static long randomLongBetween(long start, long end, SecureRandom secureRandom) {
        return start + RandomLongFactory.randomLong(end - start, RandomAlgorithm.SECURE_RANDOM, Objects.requireNonNull(secureRandom));
    }
}

