/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.random.object;

import io.github.astrapi69.collection.list.ListFactory;
import io.github.astrapi69.copy.object.CopyObjectExtensions;
import io.github.astrapi69.lang.ClassExtensions;
import io.github.astrapi69.random.DefaultSecureRandom;
import io.github.astrapi69.random.RandomCharacters;
import io.github.astrapi69.random.date.RandomDateFactory;
import io.github.astrapi69.random.enumeration.RandomAlgorithm;
import io.github.astrapi69.random.number.RandomBigDecimalFactory;
import io.github.astrapi69.random.number.RandomBigIntegerFactory;
import io.github.astrapi69.random.number.RandomBooleanFactory;
import io.github.astrapi69.random.number.RandomByteFactory;
import io.github.astrapi69.random.number.RandomCharFactory;
import io.github.astrapi69.random.number.RandomDoubleFactory;
import io.github.astrapi69.random.number.RandomFloatFactory;
import io.github.astrapi69.random.number.RandomIntFactory;
import io.github.astrapi69.random.number.RandomLongFactory;
import io.github.astrapi69.random.number.RandomShortFactory;
import io.github.astrapi69.random.object.RandomStringFactory;
import io.github.astrapi69.reflection.InstanceFactory;
import io.github.astrapi69.reflection.ReflectionExtensions;
import java.awt.Point;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public final class RandomObjectFactory {
    private RandomObjectFactory() {
    }

    public static RandomAlgorithm newRandomAlgorithm() {
        return (RandomAlgorithm)RandomObjectFactory.randomEnumFromEnumValues((Enum[])RandomAlgorithm.values());
    }

    public static Byte[] newRandomByteObjects(int length) {
        Byte[] randomByteObjects = new Byte[length];
        byte[] randomBytes = RandomByteFactory.randomByteArray(length);
        for (int i = 0; i < length; ++i) {
            randomByteObjects[i] = randomBytes[i];
        }
        return randomByteObjects;
    }

    public static Float newRandomFloat(int afterComma, int beforeComma) {
        return Float.valueOf(RandomFloatFactory.randomFloat(afterComma, beforeComma));
    }

    public static <T> T newRandomObject(Class<T> cls, String ... ignoreFieldNames) throws IllegalAccessException, InstantiationException, NoSuchFieldException {
        Objects.requireNonNull(cls);
        Object instance = InstanceFactory.newInstance(cls, (Object[])new Object[0]);
        return (T)RandomObjectFactory.setRandomValues(cls, instance, ignoreFieldNames);
    }

    public static <T> T newRandomObject(T obj, String ... ignoreFieldNames) throws IllegalAccessException, InstantiationException, NoSuchFieldException {
        Objects.requireNonNull(obj);
        Class<?> cls = obj.getClass();
        Object copy = CopyObjectExtensions.copyObject(obj, (String[])ignoreFieldNames);
        return (T)RandomObjectFactory.setRandomValues(cls, copy, ignoreFieldNames);
    }

    public static Object newRandomValue(Field field) throws IllegalAccessException, InstantiationException, NoSuchFieldException {
        Class<?> fieldType = field.getType();
        if (fieldType.isEnum()) {
            Object randomEnum = RandomObjectFactory.randomEnumFromClassname(fieldType.getCanonicalName());
            return randomEnum;
        }
        if (fieldType.equals(Void.TYPE) || fieldType.equals(Void.class)) {
            return null;
        }
        if (fieldType.equals(Byte.TYPE) || fieldType.equals(Byte.class)) {
            return RandomByteFactory.randomByte();
        }
        if (fieldType.equals(Character.TYPE) || fieldType.equals(Character.class)) {
            return Character.valueOf(RandomCharFactory.randomChar());
        }
        if (fieldType.equals(Short.TYPE) || fieldType.equals(Short.class)) {
            return RandomShortFactory.randomShort();
        }
        if (fieldType.equals(Boolean.TYPE) || fieldType.equals(Boolean.class)) {
            return RandomBooleanFactory.randomBoolean();
        }
        if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
            return RandomIntFactory.randomInt();
        }
        if (fieldType.equals(Long.TYPE) || fieldType.equals(Long.class)) {
            return RandomLongFactory.randomLong();
        }
        if (fieldType.equals(Double.TYPE) || fieldType.equals(Double.class)) {
            return RandomDoubleFactory.randomDouble();
        }
        if (fieldType.equals(Float.TYPE) || fieldType.equals(Float.class)) {
            return Float.valueOf(RandomFloatFactory.randomFloat());
        }
        if (fieldType.equals(String.class)) {
            return RandomStringFactory.newRandomString();
        }
        if (fieldType.equals(BigInteger.class)) {
            return RandomBigIntegerFactory.randomBigInteger();
        }
        if (fieldType.equals(BigDecimal.class)) {
            return RandomBigDecimalFactory.randomBigDecimal();
        }
        if (fieldType.equals(Date.class)) {
            return RandomDateFactory.randomDate();
        }
        if (fieldType.equals(LocalDateTime.class)) {
            return RandomDateFactory.randomLocalDateTime();
        }
        if (fieldType.equals(LocalDate.class)) {
            return RandomDateFactory.randomLocalDate();
        }
        if (fieldType.equals(LocalTime.class)) {
            return RandomDateFactory.randomLocalTime();
        }
        return RandomObjectFactory.newRandomObject(fieldType, new String[0]);
    }

    public static <T> T setRandomValues(Class<T> cls, T instance, String ... ignoreFieldNames) throws IllegalAccessException, InstantiationException, NoSuchFieldException {
        Objects.requireNonNull(cls);
        Objects.requireNonNull(instance);
        Field[] allDeclaredFields = ReflectionExtensions.getAllDeclaredFields(cls, (String[])ignoreFieldNames);
        List<String> toIgnoreFields = Arrays.asList(ignoreFieldNames);
        for (Field field : allDeclaredFields) {
            if (Modifier.isFinal(field.getModifiers()) || toIgnoreFields.contains(field.getName())) continue;
            Object value = RandomObjectFactory.newRandomValue(field);
            ReflectionExtensions.setFieldValue(instance, (Field)field, (Object)value);
        }
        return instance;
    }

    public static <T> T randomListEntry(List<T> list) {
        return list.get(RandomObjectFactory.randomIndex(list));
    }

    public static <K, V> Object randomMapEntry(Map<K, V> map) {
        Object[] entries = map.values().toArray();
        return entries[RandomIntFactory.randomInt(entries.length)];
    }

    public static <T extends Enum<?>> T randomEnumFromClass(Class<T> clazz) {
        return (T)RandomObjectFactory.randomEnumFromEnumValues((Enum[])((Enum[])clazz.getEnumConstants()));
    }

    public static <T extends Enum<?>> T randomEnumFromClassname(String classname) {
        if (classname != null && !classname.isEmpty()) {
            try {
                Class enumClass = ClassExtensions.forName((String)classname);
                return RandomObjectFactory.randomEnumFromClass(enumClass);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public static <T extends Enum<?>> T randomEnumFromEnumValues(T[] values) {
        return values[RandomIntFactory.randomInt(values.length)];
    }

    public static <T extends Enum<?>> T randomEnumFromObject(T obj) {
        if (obj != null) {
            Class<?> clazz = obj.getClass();
            return (T)RandomObjectFactory.randomEnumFromClass(clazz);
        }
        return null;
    }

    public static <T> int randomIndex(Collection<T> list) {
        return RandomIntFactory.randomInt(list.size());
    }

    public static <K, V> Object randomKey(Map<K, V> map) {
        Set<K> keySet = map.keySet();
        Object[] keys = keySet.toArray();
        return keys[RandomIntFactory.randomInt(keys.length)];
    }

    public static byte[] randomSalt(int length, Charset charset) {
        return RandomStringFactory.newRandomString(RandomCharacters.lowcaseWithUppercaseAndNumbers.getCharacters(), length).getBytes(charset);
    }

    public static int randomPixel() {
        return RandomObjectFactory.randomPixel(RandomIntFactory.randomInt(256), RandomIntFactory.randomInt(256), RandomIntFactory.randomInt(256), RandomIntFactory.randomInt(256));
    }

    public static int randomPixel(int red, int green, int blue, int alpha) {
        int pixel = alpha << 24 | red << 16 | green << 8 | blue;
        return pixel;
    }

    public static byte[] newSalt() {
        return RandomByteFactory.randomByteArray(16);
    }

    public static Point randomNeighborPoint(Point fromPoint) {
        return RandomObjectFactory.randomNeighborPoint(fromPoint, false);
    }

    public static Point randomNeighborPoint(Point fromPoint, boolean withNegativeValues) {
        int xMinusOne;
        int yMinusOne;
        if (withNegativeValues) {
            yMinusOne = fromPoint.y - 1;
            xMinusOne = fromPoint.x - 1;
        } else {
            yMinusOne = 0 < fromPoint.y ? fromPoint.y - 1 : fromPoint.y;
            xMinusOne = 0 < fromPoint.x ? fromPoint.x - 1 : fromPoint.x;
        }
        int yPlusOne = fromPoint.y + 1;
        int xPlusOne = fromPoint.x + 1;
        Point top = new Point(fromPoint.x, yMinusOne);
        Point bottom = new Point(fromPoint.x, yPlusOne);
        Point right = new Point(xPlusOne, fromPoint.y);
        Point left = new Point(xMinusOne, fromPoint.y);
        Point topLeft = new Point(xMinusOne, yMinusOne);
        Point topRight = new Point(xPlusOne, yMinusOne);
        Point bottomRight = new Point(xPlusOne, yPlusOne);
        Point bottomLeft = new Point(xMinusOne, yPlusOne);
        List pointList = ListFactory.newArrayList((Object[])new Point[]{top, bottom, right, left, topLeft, topRight, bottomRight, bottomLeft});
        return (Point)RandomObjectFactory.randomListEntry(pointList);
    }

    public static String randomToken() {
        BigInteger token = new BigInteger(130, DefaultSecureRandom.get());
        String randomToken = token.toString(32);
        return randomToken;
    }

    public static UUID randomUUID() {
        return UUID.randomUUID();
    }
}

