/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.random.object;

import io.github.astrapi69.random.RandomCharacters;
import io.github.astrapi69.random.number.RandomCharFactory;
import io.github.astrapi69.random.number.RandomIntFactory;

public final class RandomStringFactory {
    private RandomStringFactory() {
    }

    public static String newRandomString() {
        return RandomStringFactory.newRandomString(RandomCharacters.lowcaseWithUppercaseAndNumbers.getCharacters(), RandomIntFactory.randomIntBetween(3, 25));
    }

    public static String newRandomString(int length) {
        int maxLength = Math.min(length, 1024);
        StringBuilder sb = new StringBuilder(maxLength);
        for (int i = 0; i < maxLength; ++i) {
            sb.append(RandomCharFactory.randomChar());
        }
        return sb.toString();
    }

    public static String newRandomLongString(long length) {
        String allRandomCharacters = RandomCharacters.lowcaseWithUppercaseAndNumbersAndSpecial.getCharacters() + RandomCharacters.escapeSequencesWithWhitespace.getCharacters();
        return RandomStringFactory.newRandomLongString(allRandomCharacters, length);
    }

    public static String newRandomString(int start, int end) {
        return RandomStringFactory.newRandomString(RandomIntFactory.randomIntBetween(start, end));
    }

    public static String newRandomString(String chars, int length) {
        return RandomStringFactory.newRandomLongString(chars, length);
    }

    public static String newRandomLongString(String chars, long length) {
        StringBuilder sb = new StringBuilder();
        for (long i = 0L; i < length; ++i) {
            sb.append(RandomCharFactory.randomChar(chars));
        }
        return sb.toString();
    }

    public static String newRandomString(String[] array) {
        return array[RandomIntFactory.randomInt(array.length)];
    }

    public static String randomHexString(int numberOfCharacters) {
        StringBuilder sb = new StringBuilder();
        while (sb.length() < numberOfCharacters) {
            sb.append(Integer.toHexString(RandomIntFactory.randomInt()));
        }
        return sb.substring(0, numberOfCharacters);
    }
}

