/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.random.object;

import io.github.astrapi69.random.RandomCharacters;
import io.github.astrapi69.random.number.RandomIntFactory;
import io.github.astrapi69.random.number.RandomNumberExtensions;
import io.github.astrapi69.random.object.RandomStringFactory;
import java.util.ArrayList;
import java.util.Optional;

public final class RandomWebObjectFactory {
    private RandomWebObjectFactory() {
    }

    public static String getInfomailFromWebsite(String url) {
        int startIndex = url.indexOf("www.");
        StringBuilder email = new StringBuilder();
        if (0 < startIndex) {
            String emailprefix = "info";
            email.append("info");
            email.append("@");
            email.append(url.substring(startIndex + 4));
        } else if (0 == startIndex) {
            String emailprefix = "info";
            email.append("info");
            email.append("@");
            email.append(url.substring(startIndex + 2));
        } else {
            throw new IllegalArgumentException(url);
        }
        return email.toString();
    }

    public static String randomEmail() {
        StringBuilder email = new StringBuilder();
        String emailprefix = RandomStringFactory.newRandomString(RandomCharacters.lowcaseWithNumbers.getCharacters(), RandomIntFactory.randomInt(20) + 1);
        String domain = RandomStringFactory.newRandomString(RandomCharacters.lowcase.getCharacters(), RandomIntFactory.randomInt(12) + 1);
        String topDomain = RandomStringFactory.newRandomString(RandomCharacters.lowcase.getCharacters(), 2);
        email.append(emailprefix);
        email.append("@");
        email.append(domain);
        email.append(".");
        email.append(topDomain);
        return email.toString();
    }

    public static String randomFaxnumber(String phonenumber) {
        StringBuilder sb = new StringBuilder();
        int length = phonenumber.length();
        String randomFax = phonenumber.substring(0, length - 2);
        sb.append(randomFax);
        String phoneExtension = phonenumber.substring(length - 2, length);
        Integer phEx = Integer.valueOf(phoneExtension);
        int pe = phEx + 1;
        sb.append(pe);
        return sb.toString();
    }

    public static String randomMobilnumber() {
        StringBuilder randomPhonenumber = new StringBuilder();
        randomPhonenumber.append("0");
        randomPhonenumber.append(RandomNumberExtensions.getRandomNumericString(3));
        randomPhonenumber.append("/");
        randomPhonenumber.append(RandomNumberExtensions.getRandomNumericString(7));
        return randomPhonenumber.toString();
    }

    public static String randomPassword(int length) {
        String password = RandomStringFactory.newRandomString(RandomCharacters.lowcaseWithUppercaseAndNumbers.getCharacters(), length);
        return password;
    }

    public static String randomPassword(Optional<Integer> length) {
        if (length.isPresent()) {
            String password = RandomStringFactory.newRandomString(RandomCharacters.lowcaseWithUppercaseAndNumbers.getCharacters(), (int)length.get());
            return password;
        }
        return RandomStringFactory.newRandomString(RandomCharacters.lowcaseWithUppercaseAndNumbers.getCharacters(), 8);
    }

    public static String randomPhonenumber() {
        StringBuilder randomPhonenumber = new StringBuilder();
        randomPhonenumber.append("0");
        randomPhonenumber.append(RandomNumberExtensions.getRandomNumericString(4));
        randomPhonenumber.append("/");
        randomPhonenumber.append(RandomNumberExtensions.getRandomNumericString(7));
        return randomPhonenumber.toString();
    }

    public static String randomWebsite() {
        StringBuilder website = new StringBuilder();
        String websitePrefix = "http://www";
        String domain = RandomStringFactory.newRandomString(RandomCharacters.lowcase.getCharacters(), RandomIntFactory.randomInt(12) + 1);
        String topDomain = RandomStringFactory.newRandomString(RandomCharacters.lowcase.getCharacters(), 2);
        website.append("http://www");
        website.append(".");
        website.append(domain);
        website.append(".");
        website.append(topDomain);
        return website.toString();
    }

    public static String randomId() {
        StringBuilder sb = new StringBuilder();
        sb.append(RandomStringFactory.newRandomString(RandomCharacters.lowcaseWithUppercaseAndNumbers.getCharacters(), 2));
        sb.append(".");
        sb.append(RandomStringFactory.newRandomString(RandomCharacters.lowcaseWithUppercaseAndNumbers.getCharacters(), 4));
        sb.append(".");
        sb.append(RandomStringFactory.newRandomString(RandomCharacters.lowcaseWithUppercaseAndNumbers.getCharacters(), 2));
        sb.append(".");
        sb.append(System.currentTimeMillis());
        sb.append(".");
        sb.append(RandomStringFactory.newRandomString(RandomCharacters.lowcaseWithUppercaseAndNumbers.getCharacters(), 2));
        return sb.toString();
    }

    public static String randomName(char[] donatedChars) {
        StringBuilder sb = new StringBuilder(donatedChars.length);
        ArrayList<Character> dc = new ArrayList<Character>(donatedChars.length);
        for (char donatedChar : donatedChars) {
            dc.add(Character.valueOf(donatedChar));
        }
        boolean fullList = true;
        while (fullList) {
            int randomIndex = RandomIntFactory.randomInt(dc.size());
            Character c = (Character)dc.get(randomIndex);
            sb.append(c);
            dc.remove(randomIndex);
            if (!dc.isEmpty()) continue;
            fullList = false;
        }
        return sb.toString();
    }
}

