/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.collection.pair;

import java.io.Serializable;

public class ImmutableBox<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final T value;

    public ImmutableBox(T value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    public static <T> ImmutableBoxBuilder<T> builder() {
        return new ImmutableBoxBuilder();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImmutableBox;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImmutableBox)) {
            return false;
        }
        ImmutableBox other = (ImmutableBox)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public T getValue() {
        return this.value;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public ImmutableBoxBuilder<T> toBuilder() {
        return new ImmutableBoxBuilder<T>().value(this.value);
    }

    public String toString() {
        return "ImmutableBox(value=" + this.getValue() + ")";
    }

    public static class ImmutableBoxBuilder<T> {
        private T value;

        ImmutableBoxBuilder() {
        }

        public ImmutableBox<T> build() {
            return new ImmutableBox<T>(this.value);
        }

        public String toString() {
            return "ImmutableBox.ImmutableBoxBuilder(value=" + this.value + ")";
        }

        public ImmutableBoxBuilder<T> value(T value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
            return this;
        }
    }
}

