/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.collection.pair;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class KeyValuePair<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private K key;
    private V value;

    public KeyValuePair() {
    }

    public KeyValuePair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public static <K, V> KeyValuePairBuilder<K, V> builder() {
        return new KeyValuePairBuilder();
    }

    public static <K, V> List<KeyValuePair<K, V>> toKeyValuePairs(Map<K, V> map) {
        ArrayList<KeyValuePair<K, V>> list = new ArrayList<KeyValuePair<K, V>>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            list.add(KeyValuePair.builder().key(entry.getKey()).value(entry.getValue()).build());
        }
        return list;
    }

    public static List<KeyValuePair<String, String>> toKeyValuePairs(Properties properties) {
        ArrayList<KeyValuePair<String, String>> list = new ArrayList<KeyValuePair<String, String>>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            list.add(KeyValuePair.builder().key((String)entry.getKey()).value((String)entry.getValue()).build());
        }
        return list;
    }

    public static <K, V> Map<K, V> toMap(Collection<KeyValuePair<K, V>> list) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (KeyValuePair<K, V> keyValuePair : list) {
            map.put(keyValuePair.getKey(), keyValuePair.getValue());
        }
        return map;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyValuePair)) {
            return false;
        }
        KeyValuePair other = (KeyValuePair)o;
        K this$key = this.getKey();
        K other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        V this$value = this.getValue();
        V other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public K getKey() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        K $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        V $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public KeyValuePairBuilder<K, V> toBuilder() {
        return new KeyValuePairBuilder().key(this.key).value(this.value);
    }

    public String toString() {
        return "KeyValuePair(key=" + this.getKey() + ", value=" + this.getValue() + ")";
    }

    public static class KeyValuePairBuilder<K, V> {
        private K key;
        private V value;

        KeyValuePairBuilder() {
        }

        public KeyValuePair<K, V> build() {
            return new KeyValuePair<K, V>(this.key, this.value);
        }

        public KeyValuePairBuilder<K, V> key(K key) {
            this.key = key;
            return this;
        }

        public String toString() {
            return "KeyValuePair.KeyValuePairBuilder(key=" + this.key + ", value=" + this.value + ")";
        }

        public KeyValuePairBuilder<K, V> value(V value) {
            this.value = value;
            return this;
        }
    }
}

