/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.collection.pair;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public final class KeyValuesPair<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private K key;
    private Collection<V> values;

    public KeyValuesPair() {
    }

    public KeyValuesPair(K key, Collection<V> values) {
        this.key = key;
        this.values = values;
    }

    public static <K, V> KeyValuesPairBuilder<K, V> builder() {
        return new KeyValuesPairBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyValuesPair)) {
            return false;
        }
        KeyValuesPair other = (KeyValuesPair)o;
        K this$key = this.getKey();
        K other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        Collection<V> this$values = this.getValues();
        Collection<V> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    public K getKey() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public Collection<V> getValues() {
        return this.values;
    }

    public void setValues(Collection<V> values) {
        this.values = values;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        K $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        Collection<V> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    public KeyValuesPairBuilder<K, V> toBuilder() {
        KeyValuesPairBuilder builder = new KeyValuesPairBuilder().key(this.key);
        if (this.values != null) {
            builder.values(this.values);
        }
        return builder;
    }

    public String toString() {
        return "KeyValuesPair(key=" + this.getKey() + ", values=" + this.getValues() + ")";
    }

    public static class KeyValuesPairBuilder<K, V> {
        private K key;
        private ArrayList<V> values;

        KeyValuesPairBuilder() {
        }

        public KeyValuesPair<K, V> build() {
            return new KeyValuesPair(this.key, switch (this.values == null ? 0 : this.values.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.values.get(0));
                default -> Collections.unmodifiableList(new ArrayList<V>(this.values));
            });
        }

        public KeyValuesPairBuilder<K, V> clearValues() {
            if (this.values != null) {
                this.values.clear();
            }
            return this;
        }

        public KeyValuesPairBuilder<K, V> key(K key) {
            this.key = key;
            return this;
        }

        public String toString() {
            return "KeyValuesPair.KeyValuesPairBuilder(key=" + this.key + ", values=" + this.values + ")";
        }

        public KeyValuesPairBuilder<K, V> value(V value) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.add(value);
            return this;
        }

        public KeyValuesPairBuilder<K, V> values(Collection<? extends V> values) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.addAll(values);
            return this;
        }
    }
}

