/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.collection.array;

import io.github.astrapi69.check.Argument;
import io.github.astrapi69.collection.array.ArrayFactory;
import io.github.astrapi69.collection.list.ListFactory;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ArrayExtensions {
    private ArrayExtensions() {
    }

    public static <T> T[] arraycopyWithSystem(T[] source, T[] destination) {
        if (source == null) {
            return null;
        }
        System.arraycopy(source, 0, destination, 0, source.length);
        return destination;
    }

    public static <T> List<T> asList(T[] array) {
        return Arrays.asList(array);
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... array) {
        return Stream.of(array).collect(Collectors.toSet());
    }

    @SafeVarargs
    public static <T> Stream<T> asStream(T ... array) {
        return Arrays.stream(array);
    }

    public static <T> boolean contains(T[] array, T element) {
        return ArrayExtensions.indexOf(array, element) >= 0;
    }

    public static <T> T[] concatenate(T[] existingArray, T[] elements) {
        if (elements == null || elements.length == 0) {
            return existingArray;
        }
        if (existingArray == null) {
            return elements;
        }
        int existingArrayLength = existingArray.length;
        int elementsLength = elements.length;
        ?[] concatenatedArray = ArrayFactory.newArray(existingArray.getClass().getComponentType(), existingArrayLength + elementsLength);
        System.arraycopy(existingArray, 0, concatenatedArray, 0, existingArrayLength);
        System.arraycopy(elements, 0, concatenatedArray, existingArrayLength, elementsLength);
        return concatenatedArray;
    }

    @SafeVarargs
    public static <T> boolean containsAtLeastOne(T[] array, T ... elements) {
        boolean contains = false;
        for (T element : elements) {
            if (!ArrayExtensions.contains(array, element)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static <T> T getFirst(T[] array) {
        return ArrayExtensions.getFirstElement(array).orElse(null);
    }

    public static <T> Optional<T> getFirstElement(T[] array) {
        if (array != null && array.length != 0) {
            return Optional.of(array[0]);
        }
        return Optional.empty();
    }

    public static <T> int getIndex(T[] array, T element) {
        return ArrayExtensions.indexOf(array, element);
    }

    public static <T> T getLast(T[] array) {
        return ArrayExtensions.getLastElement(array).orElse(null);
    }

    public static <T> Optional<T> getLastElement(T[] array) {
        if (array != null && array.length != 0) {
            return Optional.of(array[ArrayExtensions.getLastIndex(array)]);
        }
        return Optional.empty();
    }

    public static <T> int getLastIndex(T[] array) {
        if (array == null) {
            return -1;
        }
        return array.length - 1;
    }

    public static int getLastIndex(boolean[] array) {
        if (array == null) {
            return -1;
        }
        return array.length - 1;
    }

    public static int getLastIndex(byte[] array) {
        if (array == null) {
            return -1;
        }
        return array.length - 1;
    }

    public static int getLastIndex(char[] array) {
        if (array == null) {
            return -1;
        }
        return array.length - 1;
    }

    public static int getLastIndex(float[] array) {
        if (array == null) {
            return -1;
        }
        return array.length - 1;
    }

    public static int getLastIndex(long[] array) {
        if (array == null) {
            return -1;
        }
        return array.length - 1;
    }

    public static int getLastIndex(short[] array) {
        if (array == null) {
            return -1;
        }
        return array.length - 1;
    }

    public static int getLastIndex(double[] array) {
        if (array == null) {
            return -1;
        }
        return array.length - 1;
    }

    public static int getLastIndex(int[] array) {
        if (array == null) {
            return -1;
        }
        return array.length - 1;
    }

    public static <T> int getNextIndex(T[] array, T element) {
        int indexOfElement = ArrayExtensions.indexOf(array, element);
        if (indexOfElement == -1) {
            return indexOfElement;
        }
        int lastIndex = ArrayExtensions.getLastIndex(array);
        if (indexOfElement == lastIndex) {
            return 0;
        }
        return indexOfElement + 1;
    }

    public static <T> int[] getNextIndexes(T[] array, T element, int count) {
        if (element != null) {
            int[] nextIndexes = new int[count];
            T currentElement = element;
            for (int i = 0; i < count; ++i) {
                int nextIndex = ArrayExtensions.getNextIndex(array, currentElement);
                if (nextIndex == -1) {
                    return null;
                }
                nextIndexes[i] = nextIndex;
                currentElement = array[nextIndex];
            }
            return nextIndexes;
        }
        return null;
    }

    public static <T> int getPreviousIndex(T[] array, T element) {
        int lastIndex = ArrayExtensions.getLastIndex(array);
        int indexOfElement = ArrayExtensions.indexOf(array, element);
        if (indexOfElement == -1) {
            return indexOfElement;
        }
        if (indexOfElement == 0) {
            return lastIndex;
        }
        return indexOfElement - 1;
    }

    public static <T> int[] getPreviousIndexes(T[] array, T element, int count) {
        if (element != null) {
            int[] previousIndexes = new int[count];
            T currentElement = element;
            for (int i = 0; i < count; ++i) {
                int previousIndex = ArrayExtensions.getPreviousIndex(array, currentElement);
                if (previousIndex == -1) {
                    return null;
                }
                previousIndexes[i] = previousIndex;
                currentElement = array[previousIndex];
            }
            return previousIndexes;
        }
        return null;
    }

    public static <T> boolean hasNext(T[] array, T element) {
        Argument.notNull(array, (String)"array");
        int indexOfElement = ArrayExtensions.indexOf(array, element);
        if (indexOfElement == -1) {
            return false;
        }
        return indexOfElement < array.length - 1;
    }

    public static <T> boolean hasPrevious(T[] array, T element) {
        Argument.notNull(array, (String)"array");
        int indexOfElement = ArrayExtensions.indexOf(array, element);
        return indexOfElement != -1 && indexOfElement != 0;
    }

    public static <T> Optional<T> getPreviousElement(T[] array, T element) {
        Argument.notNull(array, (String)"array");
        int indexOfElement = ArrayExtensions.indexOf(array, element);
        if (indexOfElement == -1 || indexOfElement == 0) {
            return Optional.empty();
        }
        int previousIndex = indexOfElement - 1;
        return Optional.of(array[previousIndex]);
    }

    public static <T> Optional<T> getNextElement(T[] array, T element) {
        Argument.notNull(array, (String)"array");
        if (ArrayExtensions.hasNext(array, element)) {
            int nextIndex = ArrayExtensions.getNextIndex(array, element);
            return Optional.of(array[nextIndex]);
        }
        return Optional.empty();
    }

    public static <T> int indexOf(T[] array, T element) {
        return Arrays.asList(array).indexOf(element);
    }

    public static <T> T[] intersection(T[] one, T[] other) {
        Argument.notNull(one, (String)"one");
        Argument.notNull(other, (String)"other");
        T[] intersection = ArrayFactory.newEmptyArray(one);
        int j = 0;
        for (int i = 0; i < one.length; ++i) {
            if (!ArrayExtensions.contains(other, one[i])) continue;
            intersection[j++] = one[i];
        }
        return ArrayFactory.newSubArray(intersection, 0, j);
    }

    public static <T> boolean isFirst(T[] array, T element) {
        int indexOfElement = Arrays.asList(array).indexOf(element);
        return indexOfElement == 0;
    }

    public static <T> boolean isLast(T[] array, T element) {
        int lastIndex = ArrayExtensions.getLastIndex(array);
        int indexOfElement = Arrays.asList(array).indexOf(element);
        return indexOfElement == lastIndex;
    }

    public static <T> T[] remove(T[] array, int ... indexes) {
        Argument.notNull(array, (String)"array");
        List<T> list = ListFactory.newArrayList(array);
        int lastIndex = indexes.length - 1;
        Arrays.sort(indexes);
        for (int i = lastIndex; -1 < i; --i) {
            int index = indexes[i];
            list.remove(index);
        }
        return list.toArray(Arrays.copyOf(array, list.size()));
    }

    public static <T> T[] removeAll(T[] array, T[] arrayToRemove) {
        Argument.notNull(array, (String)"array");
        Argument.notNull(arrayToRemove, (String)"arrayToRemove");
        List<T> list = ListFactory.newArrayList(array);
        List<T> listToRemove = ListFactory.newArrayList(arrayToRemove);
        list.removeAll(listToRemove);
        return list.toArray(Arrays.copyOf(array, list.size()));
    }

    public static <T> T[] removeFirst(T[] original) {
        Argument.notNull(original, (String)"original");
        return ArrayExtensions.remove(original, 0);
    }

    public static <T> T[] removeFromEnd(T[] array, T[] suffix) {
        return Arrays.copyOf(array, array.length - suffix.length);
    }

    public static <T> T[] removeFromStart(T[] array, T[] prefix) {
        Argument.notNull(array, (String)"array");
        Argument.notNull(prefix, (String)"prefix");
        if (0 < array.length) {
            ?[] result = ArrayFactory.newArray(array[0].getClass(), array.length - prefix.length);
            System.arraycopy(array, prefix.length, result, 0, result.length);
            return result;
        }
        return array;
    }

    public static <T> T[] removeLast(T[] original) {
        Argument.notNull(original, (String)"original");
        return Arrays.copyOf(original, original.length - 1);
    }

    public static byte[][] splitInChunks(byte[] bytes, int chunkSize) {
        int count;
        int size = (bytes.length - 1) / chunkSize + 1;
        byte[][] dataChunks = new byte[size][];
        int to = bytes.length;
        int from = count * chunkSize;
        for (count = size - 1; -1 < count; --count) {
            dataChunks[count] = Arrays.copyOfRange(bytes, from, to);
            to = from;
            from = to - chunkSize;
        }
        return dataChunks;
    }

    public static <T> T[] subArray(T[] original, int start, int end) {
        return Arrays.copyOfRange(original, start, end);
    }

    public static <T> List<T> toList(T[] array) {
        return ArrayExtensions.asList(array);
    }

    public static <T> T[][] toTwoDimensionalArray(Map<T, T> map, Class<T> cls) {
        Argument.notNull(map, (String)"map");
        Argument.notNull(cls, (String)"cls");
        Object[][] array = (Object[][])Array.newInstance(cls, map.size(), 2);
        int count = 0;
        for (Map.Entry<T, T> entry : map.entrySet()) {
            array[count][0] = entry.getKey();
            array[count][1] = entry.getValue();
            ++count;
        }
        return array;
    }

    /*
     * Exception decompiling
     */
    public static Object[][] toTwoDimensionalArray(Map<String, Object> map) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ Object[][] lambda$toTwoDimensionalArray$1(int x$0) {
        return new Object[x$0][];
    }
}

