/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.collection.array;

import io.github.astrapi69.check.Argument;
import io.github.astrapi69.collection.array.ArrayExtensions;
import java.lang.reflect.Array;

public final class ArrayFactory {
    private ArrayFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static <T> T[] newArray(Class<T> cls, int length) {
        return (Object[])Array.newInstance(cls, length);
    }

    @SafeVarargs
    public static <T> T[] newArray(T ... elements) {
        return elements;
    }

    @SafeVarargs
    public static <T> T[] newArray(T[] existingArray, T ... elements) {
        return ArrayExtensions.concatenate(existingArray, elements);
    }

    @SafeVarargs
    public static boolean[] newBooleanArray(boolean ... elements) {
        return elements;
    }

    @SafeVarargs
    public static byte[] newByteArray(byte ... elements) {
        return elements;
    }

    @SafeVarargs
    public static byte[] newByteArray(int ... elements) {
        byte[] array = new byte[]{};
        if (elements != null && 0 < elements.length) {
            array = new byte[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                array[i] = (byte)elements[i];
            }
        }
        return array;
    }

    @SafeVarargs
    public static char[] newCharArray(char ... elements) {
        return elements;
    }

    @SafeVarargs
    public static double[] newDoubleArray(double ... elements) {
        return elements;
    }

    public static <T> T[] newEmptyArray(T[] array) {
        Argument.notNull(array, (String)"array");
        return ArrayFactory.newEmptyArray(array, array.length);
    }

    public static <T> T[] newEmptyArray(T[] array, int length) {
        Argument.notNull(array, (String)"array");
        return (Object[])Array.newInstance(array.getClass().getComponentType(), length);
    }

    @SafeVarargs
    public static float[] newFloatArray(float ... elements) {
        return elements;
    }

    @SafeVarargs
    public static int[] newIntArray(int ... elements) {
        return elements;
    }

    @SafeVarargs
    public static long[] newLongArray(long ... elements) {
        return elements;
    }

    public static Integer[] newRangeArray(int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("Parameter end should be greater than parameter start.");
        }
        int length = end - start + 1;
        Integer[] array = new Integer[length];
        for (int i = start; i <= end; ++i) {
            array[i - start] = i;
        }
        return array;
    }

    @SafeVarargs
    public static short[] newShortArray(short ... elements) {
        return elements;
    }

    public static <T> T[] newSubArray(T[] source, int startIndex, int endIndex) {
        Argument.notNull(source, (String)"source");
        int newSize = endIndex - startIndex;
        T[] subArray = ArrayFactory.newEmptyArray(source, newSize);
        for (int i = 0; i < newSize; ++i) {
            subArray[i] = source[i + startIndex];
        }
        return subArray;
    }
}

