/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.collection.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<E>
implements Iterator<E> {
    private final E[] array;
    private int pos = 0;

    public ArrayIterator(E[] array) {
        this.array = array;
    }

    public E[] getArray() {
        return this.array;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.array.length && this.array[this.pos] != null;
    }

    @Override
    public E next() throws NoSuchElementException {
        E next;
        try {
            next = this.array[this.pos];
        }
        catch (RuntimeException e) {
            throw new NoSuchElementException("");
        }
        ++this.pos;
        return next;
    }

    @Override
    public void remove() {
        if (this.pos <= 0) {
            throw new IllegalStateException("The method next() was not invoked.");
        }
        if (this.array[this.pos - 1] != null) {
            for (int i = this.pos - 1; i < this.array.length - 1; ++i) {
                this.array[i] = this.array[i + 1];
            }
            this.array[this.array.length - 1] = null;
        }
    }
}

