/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.collection.list;

import io.github.astrapi69.check.Argument;
import io.github.astrapi69.check.Check;
import io.github.astrapi69.collection.CollectionExtensions;
import io.github.astrapi69.collection.array.ArrayFactory;
import io.github.astrapi69.collection.list.ListFactory;
import io.github.astrapi69.collection.map.MapFactory;
import io.github.astrapi69.collection.modification.ModifiedCollections;
import io.github.astrapi69.comparator.factory.ComparatorFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public final class ListExtensions {
    private ListExtensions() {
    }

    public static <T> T getFirst(List<T> list) {
        return ListExtensions.getFirstElement(list).orElse(null);
    }

    public static <T> T getLast(List<T> list) {
        return ListExtensions.getLastElement(list).orElse(null);
    }

    private static void computeAllCombinations(List<List<Integer>> allCombinations, List<Integer> possibleNumbers, Integer[] currentCombination, int currentStart, int currentEnd, int currentCombinationIndex, int combinationSize) {
        if (currentCombinationIndex == combinationSize) {
            allCombinations.add(ListFactory.newArrayList(currentCombination));
            return;
        }
        for (int i = currentStart; i <= currentEnd && currentEnd - i + 1 >= combinationSize - currentCombinationIndex; ++i) {
            currentCombination[currentCombinationIndex] = possibleNumbers.get(i);
            ListExtensions.computeAllCombinations(allCombinations, possibleNumbers, currentCombination, i + 1, currentEnd, currentCombinationIndex + 1, combinationSize);
        }
    }

    public static <T> boolean containAtLeastOneObject(List<T> toSearch, List<T> search) {
        boolean contains = false;
        int size = toSearch.size();
        for (int i = 0; i < size && !(contains = search.contains(toSearch.get(i))); ++i) {
        }
        return contains;
    }

    public static <T> List<T> clone(List<T> list) {
        return ListFactory.newArrayList(list, new Object[0]);
    }

    public static List<List<Integer>> getAllCombinations(List<Integer> possibleNumbers, int combinationSize) {
        Argument.notNull(possibleNumbers, (String)"possibleNumbers");
        Integer[] currentCombination = new Integer[combinationSize];
        List<List<Integer>> allCombinations = ListFactory.newArrayList(new List[0]);
        int currentEnd = possibleNumbers.size() - 1;
        int currentStart = 0;
        int currentCombinationIndex = 0;
        ListExtensions.computeAllCombinations(allCombinations, possibleNumbers, currentCombination, currentStart, currentEnd, currentCombinationIndex, combinationSize);
        return allCombinations;
    }

    public static <T> List<List<T>> getCombinations(List<T> possibleValues, int combinationSize) {
        List<List<T>> combinations = ListFactory.newArrayList(new List[0]);
        if (combinationSize == 0) {
            combinations.add(ListFactory.newArrayList(new Object[0]));
            return combinations;
        }
        for (int i = 0; i < possibleValues.size(); ++i) {
            T element = possibleValues.get(i);
            List<T> rest = ListExtensions.getPartialList(possibleValues, i + 1);
            for (List<T> previous : ListExtensions.getCombinations(rest, combinationSize - 1)) {
                previous.add(element);
                combinations.add(previous);
            }
        }
        return combinations;
    }

    public static <T> Optional<T> getFirstElement(List<T> list) {
        Argument.notNull(list, (String)"list");
        if (CollectionExtensions.isNotEmpty(list)) {
            return Optional.of(list.get(0));
        }
        return Optional.empty();
    }

    public static <T> Optional<T> getLastElement(List<T> list) {
        Argument.notNull(list, (String)"list");
        if (CollectionExtensions.isNotEmpty(list)) {
            return Optional.of(list.get(list.size() - 1));
        }
        return Optional.empty();
    }

    public static <T> ModifiedCollections<T> getModifiedCollections(Collection<T> previous, Collection<T> next) {
        return new ModifiedCollections<T>().getModifiedLists(previous, next);
    }

    public static <T> Optional<T> getNextElement(List<T> list, T element) {
        Argument.notNull(list, (String)"list");
        if (ListExtensions.hasNext(list, element)) {
            int nextIndex = list.indexOf(element) + 1;
            return Optional.of(list.get(nextIndex));
        }
        return Optional.empty();
    }

    private static <T> List<T> getPartialList(List<T> list, int i) {
        List<Object> partialList = ListFactory.newArrayList(new Object[0]);
        for (int j = i; j < list.size(); ++j) {
            partialList.add(list.get(j));
        }
        return partialList;
    }

    public static <T> Optional<T> getPreviousElement(List<T> list, T element) {
        Argument.notNull(list, (String)"list");
        int indexOfElement = list.indexOf(element);
        if (indexOfElement == -1 || indexOfElement == 0) {
            return Optional.empty();
        }
        int previousIndex = indexOfElement - 1;
        return Optional.of(list.get(previousIndex));
    }

    public static <T> List<T> getSameElementsFromLists(List<T> toSearch, List<T> search) {
        toSearch.retainAll(search);
        return ListFactory.newArrayList(toSearch, new Object[0]);
    }

    public static <T> boolean hasNext(List<T> list, T element) {
        Argument.notNull(list, (String)"list");
        int indexOfElement = list.indexOf(element);
        if (indexOfElement == -1) {
            return false;
        }
        return indexOfElement < list.size() - 1;
    }

    public static <T> boolean hasPrevious(List<T> list, T element) {
        Argument.notNull(list, (String)"list");
        int indexOfElement = list.indexOf(element);
        return indexOfElement != -1 && indexOfElement != 0;
    }

    public static <T> boolean isEqualListOfArrays(List<T[]> one, List<T[]> other) {
        Optional<Boolean> optionalEvaluation = CollectionExtensions.preconditionOfEqualCollection(one, other);
        if (optionalEvaluation.isPresent()) {
            return optionalEvaluation.get();
        }
        for (int i = 0; i < one.size(); ++i) {
            if (Arrays.deepEquals(one.get(i), other.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isFirst(List<T> list, T element) {
        int indexOfElement = list.indexOf(element);
        return indexOfElement == 0;
    }

    public static <T> boolean isLast(List<T> list, T element) {
        return ListExtensions.getLastElement(list).map(current -> current.equals(element)).orElse(false);
    }

    public static <T> List<T> rearrange(List<T> listToResort, T element, int rearrangeToIndex) {
        Argument.notNull(element, (String)"element");
        Argument.notNull(listToResort, (String)"listToResort");
        int index = listToResort.indexOf(element);
        if (index < 0 || index == rearrangeToIndex || listToResort.size() == rearrangeToIndex) {
            return listToResort;
        }
        List<Object> resortedList = ListFactory.newArrayList(listToResort, new Object[0]);
        resortedList.remove(index);
        resortedList.add(rearrangeToIndex, element);
        return resortedList;
    }

    public static <T> void relocate(List<T> list, T element, int newIndex) {
        Argument.notNull(element, (String)"element");
        Argument.notNull(list, (String)"list");
        int index = list.indexOf(element);
        if (index < 0 || index == newIndex) {
            return;
        }
        list.remove(index);
        if (list.size() <= newIndex) {
            list.add(element);
        } else {
            list.add(newIndex, element);
        }
    }

    public static <T> T removeFirst(List<T> list) {
        return ListExtensions.removeFirstElement(list).orElse(null);
    }

    public static <T> Optional<T> removeFirstElement(List<T> list) {
        Argument.notNull(list, (String)"list");
        if (!CollectionExtensions.isEmpty(list)) {
            return Optional.of(list.remove(0));
        }
        return Optional.empty();
    }

    public static <T> T removeLast(List<T> list) {
        return ListExtensions.removeLastElement(list).orElse(null);
    }

    public static <T> Optional<T> removeLastElement(List<T> list) {
        Argument.notNull(list, (String)"list");
        if (!CollectionExtensions.isEmpty(list)) {
            return Optional.of(list.remove(list.size() - 1));
        }
        return Optional.empty();
    }

    public static <T> List<T> removeLastValues(List<T> v, int remove) {
        if (remove < v.size()) {
            return v.subList(remove, v.size());
        }
        throw new IllegalArgumentException("You cannot remove more element than in the ArrayList exists. \nSize from ArrayList:" + v.size() + "\nElements to be removed:" + remove + "\n The same ArrayList will be returned.");
    }

    public static <T> List<T> revertOrder(List<T> listToRevert) {
        List<Object> revertedList = ListFactory.newArrayList(new Object[0]);
        int size = listToRevert.size();
        while (0 < size) {
            revertedList.add(listToRevert.get(--size));
        }
        return revertedList;
    }

    public static <T> void shuffle(List<T> source, List<T> destination, int[] selectedElements) {
        int lastIndex;
        for (int i = lastIndex = selectedElements.length - 1; -1 < i; --i) {
            int selectedRow = selectedElements[i];
            T row = source.remove(selectedRow);
            destination.add(row);
        }
    }

    public static <T> List<T> subList(List<T> list, int fromIndex, int toIndex) {
        if (fromIndex >= list.size() || toIndex <= 0 || fromIndex >= toIndex) {
            return ListFactory.newArrayList(new Object[0]);
        }
        fromIndex = Math.max(0, fromIndex);
        toIndex = Math.min(list.size(), toIndex);
        return list.subList(fromIndex, toIndex);
    }

    public static <T, U extends Comparable<? super U>> void sortByProperty(List<T> list, Function<? super T, ? extends U> beanPropertyFunction, boolean ascending) {
        Comparator<T> comparator = Comparator.comparing(beanPropertyFunction, Comparator.nullsFirst(Comparator.naturalOrder()));
        if (ascending) {
            comparator = comparator.reversed();
        }
        list.sort(comparator);
    }

    public static <T> List<List<T>> splitToParts(Collection<T> collection, int size) {
        List<List<T>> returnList = ListFactory.newArrayList(new List[0]);
        List<Object> tmp = ListFactory.newArrayList(new Object[0]);
        Iterator<T> it = collection.iterator();
        int count = 0;
        while (it.hasNext()) {
            if (count == size) {
                returnList.add(tmp);
                tmp = ListFactory.newArrayList(new Object[0]);
                tmp.add(it.next());
                count = 1;
                continue;
            }
            tmp.add(it.next());
            ++count;
        }
        if (!tmp.isEmpty()) {
            returnList.add(tmp);
        }
        return returnList;
    }

    public static <T> T[] toArray(List<T> list) {
        Check.get().notNull(list, "list").notEmpty(list, "list");
        ?[] newArray = ArrayFactory.newArray(list.get(0).getClass(), list.size());
        return list.toArray(newArray);
    }

    @SafeVarargs
    public static <T> T[] toArray(T ... elements) {
        return ArrayFactory.newArray(elements);
    }

    public static <T> Map<Integer, T> toIndexMap(List<T> list) {
        Check.get().notNull(list, "list").notEmpty(list, "list");
        Map<Integer, T> map = MapFactory.newLinkedHashMap(list.size());
        for (int i = 0; i < list.size(); ++i) {
            map.put(i, list.get(i));
        }
        return map;
    }

    public static <T> List<T> toList(Enumeration<T> enumeration) {
        List<Object> list = ListFactory.newArrayList(new Object[0]);
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list;
    }

    public static <T> List<T> toList(Set<T> set) {
        return ListFactory.newArrayList(set, new Object[0]);
    }

    @SafeVarargs
    public static <T> Object[] toObjectArray(T ... elements) {
        Object[] decorator = new Object[elements.length];
        System.arraycopy(elements, 0, decorator, 0, elements.length);
        return decorator;
    }

    public static <T> int getIndexToInsert(List<T> newSortedList, List<T> sortedList, T elementToAdd) {
        List<Object> listWithNewElement = ListFactory.newArrayList(newSortedList, new Object[]{elementToAdd});
        listWithNewElement.sort(ComparatorFactory.newDefinedOrderComparator(sortedList));
        return listWithNewElement.indexOf(elementToAdd);
    }

    public static <T> int getIndexToInsert(List<? extends T> list, T element, Comparator<? super T> comparator) {
        int indexToInsert = Collections.binarySearch(list, element, comparator);
        if (!list.contains(element)) {
            indexToInsert = -indexToInsert - 1;
        }
        return indexToInsert;
    }

    public static <T> boolean isBefore(List<T> list, T element, T elementToCheck) {
        ListExtensions.nullChecks(list, element, elementToCheck);
        if (list.contains(element) && list.contains(elementToCheck)) {
            int indexOfElement = list.indexOf(element);
            int indexOfElementToCheck = list.indexOf(elementToCheck);
            return indexOfElementToCheck < indexOfElement;
        }
        return false;
    }

    private static <T> void nullChecks(List<T> list, T element, T elementToCheck) {
        Objects.requireNonNull(list);
        Objects.requireNonNull(element);
        Objects.requireNonNull(elementToCheck);
    }

    public static <T> boolean isAfter(List<T> list, T element, T elementToCheck) {
        Objects.requireNonNull(list);
        Objects.requireNonNull(element);
        Objects.requireNonNull(elementToCheck);
        if (list.contains(element) && list.contains(elementToCheck)) {
            int indexOfElementToCheck;
            int indexOfElement = list.indexOf(element);
            return indexOfElement < (indexOfElementToCheck = list.indexOf(elementToCheck));
        }
        return false;
    }
}

