/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.collection.list;

import io.github.astrapi69.collection.list.ListExtensions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public class SortedArrayList<E>
extends ArrayList<E> {
    private Comparator<? super E> comparator;

    public SortedArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public SortedArrayList() {
    }

    public SortedArrayList(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    public SortedArrayList(Collection<? extends E> collection, Comparator<? super E> comparator) {
        this(comparator);
        this.addAll(collection);
    }

    @Override
    public boolean add(E element) {
        int currentSize = this.size();
        if (this.comparator == null) {
            return super.add(element);
        }
        ListExtensions.getIndexToInsert(this, element, this.comparator);
        int insertIndex = ListExtensions.getIndexToInsert(this, element, this.comparator);
        super.add(insertIndex, element);
        return this.size() != currentSize;
    }

    @Override
    public void add(int index, E element) {
        this.add(element);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean result = false;
        for (E element : collection) {
            result |= this.add(element);
        }
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        return this.addAll(collection);
    }

    public Comparator<? super E> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<? super E> comparator) {
        this.comparator = comparator;
        Collections.sort(this, comparator);
    }
}

