/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.collection.list;

import java.util.ArrayList;
import java.util.Collection;

public class UniqueArrayList<E>
extends ArrayList<E> {
    public UniqueArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public UniqueArrayList() {
    }

    public UniqueArrayList(Collection<? extends E> collection) {
        this.addAll(collection);
    }

    @Override
    public boolean add(E element) {
        if (!this.contains(element)) {
            return super.add(element);
        }
        return false;
    }

    @Override
    public void add(int index, E element) {
        if (this.contains(element)) {
            if (this.remove(element)) {
                super.add(index, element);
            }
        } else {
            super.add(index, element);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (collection.size() == 0) {
            return false;
        }
        for (E element : collection) {
            this.add(element);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        if (collection.size() == 0) {
            return false;
        }
        int currentIndex = index;
        for (E element : collection) {
            if (currentIndex >= this.size()) {
                this.add(element);
            } else {
                this.add(currentIndex, element);
            }
            ++currentIndex;
        }
        return true;
    }
}

