/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.collection.map;

import io.github.astrapi69.check.Argument;
import io.github.astrapi69.collection.list.ListFactory;
import io.github.astrapi69.collection.map.MapFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class MapExtensions {
    private MapExtensions() {
    }

    public static <K, V> K getKeyFromValue(Map<K, V> map, V value) {
        Map.Entry<K, V> entry;
        Argument.notNull(map, (String)"map");
        K key = null;
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext() && !map.get(key = (K)(entry = iterator.next()).getKey()).equals(value)) {
        }
        return key;
    }

    public static <K, V> Collection<K> getKeysFromValue(Map<K, V> map, V value) {
        Argument.notNull(map, (String)"map");
        List<Object> keys = ListFactory.newArrayList(new Object[0]);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V val = entry.getValue();
            if (!val.equals(value)) continue;
            K key = entry.getKey();
            keys.add(key);
        }
        return keys;
    }

    public static <K> Map<K, Integer> mergeAndSummarize(Map<K, Integer> valueCounterMap, Collection<K> summarizeWithThisValueCounterMap) {
        return MapExtensions.mergeAndSummarize(valueCounterMap, summarizeWithThisValueCounterMap, false);
    }

    public static <K> Map<K, Integer> mergeAndSummarize(Map<K, Integer> valueCounterMap, Collection<K> summarizeWithThisValueCounterMap, boolean fullMerge) {
        return MapExtensions.mergeAndSummarize(valueCounterMap, MapFactory.newCounterMap(MapFactory.newCounterMap(summarizeWithThisValueCounterMap), summarizeWithThisValueCounterMap), fullMerge);
    }

    public static <K> Map<K, Integer> mergeAndSummarize(Map<K, Integer> valueCounterMap, Map<K, Integer> summarizeWithThisValueCounterMap) {
        return MapExtensions.mergeAndSummarize(valueCounterMap, summarizeWithThisValueCounterMap, false);
    }

    public static <K> Map<K, Integer> mergeAndSummarize(Map<K, Integer> valueCounterMap, Map<K, Integer> summarizeWithThisValueCounterMap, boolean fullMerge) {
        return fullMerge ? Stream.of(valueCounterMap, summarizeWithThisValueCounterMap).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum)) : Stream.of(valueCounterMap, summarizeWithThisValueCounterMap).map(Map::entrySet).flatMap(Collection::stream).filter(map -> valueCounterMap.containsKey(map.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum));
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map, boolean reversed) {
        Argument.notNull(map, (String)"map");
        return MapExtensions.sortByValue(map, reversed ? Comparator.reverseOrder() : Comparator.naturalOrder());
    }

    public static <K, V> Map<V, K> swap(Map<K, V> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map, Comparator<? super V> comparator) {
        Argument.notNull(map, (String)"map");
        Argument.notNull(comparator, (String)"comparator");
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue(comparator)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (k, v) -> k, LinkedHashMap::new));
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByKey(Map<K, V> map, Comparator<? super K> comparator) {
        Argument.notNull(map, (String)"map");
        Argument.notNull(comparator, (String)"comparator");
        return map.entrySet().stream().sorted(Map.Entry.comparingByKey(comparator)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (k, v) -> k, LinkedHashMap::new));
    }

    public static <K, V extends Comparable<? super V>> K getMaxKey(Map<K, V> map, Comparator<? super K> comparator) {
        Argument.notNull(map, (String)"map");
        Argument.notNull(comparator, (String)"comparator");
        return map.entrySet().stream().max(Map.Entry.comparingByKey(comparator)).get().getKey();
    }

    public static <K, V extends Comparable<? super V>> List<Map.Entry<K, V>> sortByValueAsList(Map<K, V> map, boolean reversed) {
        Argument.notNull(map, (String)"map");
        return MapExtensions.sortByValueAsList(map, reversed ? Comparator.reverseOrder() : Comparator.naturalOrder());
    }

    public static <K, V extends Comparable<? super V>> List<Map.Entry<K, V>> sortByValueAsList(Map<K, V> map, Comparator<? super V> comparator) {
        Argument.notNull(map, (String)"map");
        Argument.notNull(comparator, (String)"comparator");
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue(comparator)).collect(Collectors.toList());
    }

    public static <T> Map<T, T> toGenericMap(T[][] twoDimArray) {
        Argument.notNull(twoDimArray, (String)"twoDimArray");
        LinkedHashMap<T, T> map = new LinkedHashMap<T, T>();
        for (T[] element : twoDimArray) {
            T key = element[0];
            T value = element[1];
            map.put(key, value);
        }
        return map;
    }

    public static Map<String, String> toMap(String[][] twoDimArray) {
        return MapExtensions.toGenericMap(twoDimArray);
    }

    public static Map<String, Object> toStringObjectMap(Object[][] twoDimArray) {
        Argument.notNull((Object)twoDimArray, (String)"twoDimArray");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Object[] element : twoDimArray) {
            String key = (String)element[0];
            Object value = element[1];
            map.put(key, value);
        }
        return map;
    }

    public static <K, V> Properties toProperties(Map<K, V> map) {
        Properties properties = new Properties();
        if (map != null) {
            Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry2;
                Map.Entry<K, V> entry = entry2 = iterator.next();
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                properties.put(key, value);
            }
        }
        return properties;
    }

    public static <K, V> List<V> valuesAsList(Map<K, V> map) {
        return new ArrayList<V>(map.values());
    }
}

