/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.collection.map;

import io.github.astrapi69.check.Argument;
import io.github.astrapi69.collection.list.ListFactory;
import io.github.astrapi69.collection.map.InsertionOrderMap;
import io.github.astrapi69.collection.map.MapExtensions;
import io.github.astrapi69.collection.pair.KeyValuePair;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.functors.InstantiateFactory;
import org.apache.commons.collections4.map.LazyMap;

public final class MapFactory {
    private MapFactory() {
    }

    public static Map<Integer, Map<String, String>> newAssosiativeArrayMap() {
        return MapFactory.newLazyMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(Map<K, V> map) {
        Argument.notNull(map, (String)"map");
        return new ConcurrentHashMap<K, V>(map);
    }

    public static <K> Map<K, Integer> newCounterMap(Collection<K> elements) {
        return MapFactory.newCounterMap(elements, true);
    }

    public static <K> Map<K, Integer> newCounterMap(Collection<K> elements, boolean startByZero) {
        Objects.requireNonNull(elements);
        return MapFactory.newCounterMap(MapFactory.newHashMap(), elements, startByZero);
    }

    public static <K> Map<K, Integer> newCounterMap(Map<K, Integer> counterMap, Collection<K> elements) {
        return MapFactory.newCounterMap(counterMap, elements, true);
    }

    public static <K> Map<K, Integer> newCounterMap(Map<K, Integer> counterMap, Collection<K> elements, boolean startByZero) {
        Objects.requireNonNull(counterMap);
        for (K element : elements) {
            if (counterMap.containsKey(element)) {
                counterMap.merge(element, 1, Integer::sum);
                continue;
            }
            if (startByZero) {
                counterMap.put(element, 0);
                continue;
            }
            counterMap.put(element, 1);
        }
        return counterMap;
    }

    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> newHashMap(Collection<KeyValuePair<K, V>> keyValuePairs) {
        Argument.notNull(keyValuePairs, (String)"keyValuePairs");
        return MapFactory.newHashMap(KeyValuePair.toMap(keyValuePairs));
    }

    public static <K, V> Map<K, V> newHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> newHashMap(KeyValuePair<K, V> ... keyValuePairs) {
        Argument.notNull(keyValuePairs, (String)"keyValuePairs");
        return MapFactory.newHashMap(ListFactory.newArrayList(keyValuePairs));
    }

    public static <K, V> Map<K, V> newHashMap(Map<K, V> map) {
        Argument.notNull(map, (String)"map");
        return new HashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> newHashMap(List<K> keys, List<V> values) {
        Argument.notNull(keys, (String)"keys");
        Argument.notNull(values, (String)"values");
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException("The list of keys and values must have the same size");
        }
        Map<K, V> map = MapFactory.newHashMap();
        for (int i = 0; i < keys.size(); ++i) {
            map.put(keys.get(i), values.get(i));
        }
        return map;
    }

    public static <K, V> Map<K, V> newInsertionOrderMap() {
        return new InsertionOrderMap();
    }

    public static <K, V> Map<K, V> newInsertionOrderMap(Collection<KeyValuePair<K, V>> keyValuePairs) {
        Argument.notNull(keyValuePairs, (String)"keyValuePairs");
        return MapFactory.newInsertionOrderMap(KeyValuePair.toMap(keyValuePairs));
    }

    public static <K, V> Map<K, V> newInsertionOrderMap(int initialCapacity) {
        return new InsertionOrderMap(initialCapacity);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> newInsertionOrderMap(KeyValuePair<K, V> ... keyValuePairs) {
        Argument.notNull(keyValuePairs, (String)"keyValuePairs");
        return MapFactory.newInsertionOrderMap(ListFactory.newArrayList(keyValuePairs));
    }

    public static <K, V> Map<K, V> newInsertionOrderMap(Map<K, V> map) {
        Argument.notNull(map, (String)"map");
        return new InsertionOrderMap<K, V>(map);
    }

    public static <K, V> Map<K, V> newLazyHashMap() {
        return MapFactory.newLazyHashMap(new HashMap());
    }

    public static <K, V> Map<K, V> newLazyHashMap(HashMap<K, V> map) {
        return LazyMap.lazyMap(map, (Factory)new InstantiateFactory(HashMap.class));
    }

    public static <K, V> Map<K, V> newLazyMap() {
        return MapFactory.newLazyHashMap();
    }

    public static <K, V> Map<K, V> newLazyTreeMap() {
        return MapFactory.newLazyTreeMap(new TreeMap());
    }

    public static <K, V> Map<K, V> newLazyTreeMap(Comparator<? super K> comparator) {
        Argument.notNull(comparator, (String)"comparator");
        return LazyMap.lazyMap(new TreeMap(comparator), (Factory)new InstantiateFactory(TreeMap.class));
    }

    public static <K, V> Map<K, V> newLazyTreeMap(TreeMap<K, V> map) {
        Argument.notNull(map, (String)"map");
        return LazyMap.lazyMap(map, (Factory)new InstantiateFactory(TreeMap.class));
    }

    public static <K, V> Map<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> newLinkedHashMap(Collection<KeyValuePair<K, V>> keyValuePairs) {
        Argument.notNull(keyValuePairs, (String)"keyValuePairs");
        return MapFactory.newLinkedHashMap(KeyValuePair.toMap(keyValuePairs));
    }

    public static <K, V> Map<K, V> newLinkedHashMap(int initialCapacity) {
        return new LinkedHashMap(initialCapacity);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> newLinkedHashMap(KeyValuePair<K, V> ... keyValuePairs) {
        Argument.notNull(keyValuePairs, (String)"keyValuePairs");
        return MapFactory.newLinkedHashMap(ListFactory.newArrayList(keyValuePairs));
    }

    public static <K, V> Map<K, V> newLinkedHashMap(Map<K, V> map) {
        Argument.notNull(map, (String)"map");
        return new LinkedHashMap<K, V>(map);
    }

    public static Map<Integer, Integer> newNumberCounterMap(int minVolume, int maxVolume) {
        return MapFactory.newCounterMap(ListFactory.newRangeList(minVolume, maxVolume));
    }

    public static Map<Integer, Integer> newNumberCounterMap(int minVolume, int maxVolume, Map<Integer, Integer> numberCounterMap) {
        Argument.notNull(numberCounterMap, (String)"numberCounterMap");
        return MapExtensions.mergeAndSummarize(MapFactory.newNumberCounterMap(minVolume, maxVolume), numberCounterMap);
    }

    public static <K, V> Map<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K, V> Map<K, V> newTreeMap(Collection<KeyValuePair<K, V>> keyValuePairs) {
        Argument.notNull(keyValuePairs, (String)"keyValuePairs");
        return MapFactory.newTreeMap(KeyValuePair.toMap(keyValuePairs));
    }

    public static <K, V> Map<K, V> newTreeMap(Comparator<? super K> comparator) {
        Argument.notNull(comparator, (String)"comparator");
        return new TreeMap(comparator);
    }

    public static <K, V> Map<K, V> newTreeMap(Comparator<? super K> comparator, Collection<KeyValuePair<K, V>> keyValuePairs) {
        Argument.notNull(comparator, (String)"comparator");
        Argument.notNull(keyValuePairs, (String)"keyValuePairs");
        TreeMap<K, V> treeMap = new TreeMap<K, V>(comparator);
        treeMap.putAll(MapFactory.newTreeMap(keyValuePairs));
        return treeMap;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> newTreeMap(Comparator<? super K> comparator, KeyValuePair<K, V> ... keyValuePairs) {
        Argument.notNull(comparator, (String)"comparator");
        Argument.notNull(keyValuePairs, (String)"keyValuePairs");
        TreeMap<K, V> treeMap = new TreeMap<K, V>(comparator);
        treeMap.putAll(MapFactory.newTreeMap(keyValuePairs));
        return treeMap;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> newTreeMap(KeyValuePair<K, V> ... keyValuePairs) {
        Argument.notNull(keyValuePairs, (String)"keyValuePairs");
        return MapFactory.newTreeMap(ListFactory.newArrayList(keyValuePairs));
    }

    public static <K, V> Map<K, V> newTreeMap(Map<K, V> map) {
        Argument.notNull(map, (String)"map");
        return new TreeMap<K, V>(map);
    }
}

