/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.collection.set;

import io.github.astrapi69.check.Argument;
import io.github.astrapi69.collection.array.ArrayFactory;
import io.github.astrapi69.collection.set.SetFactory;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;

public final class SetExtensions {
    private SetExtensions() {
    }

    public static <T> T[] toArray(Set<T> set) {
        Argument.notNull(set, (String)"set");
        if (set.isEmpty()) {
            throw new IllegalArgumentException("set is empty");
        }
        ?[] newArray = ArrayFactory.newArray(set.iterator().next().getClass(), set.size());
        return set.toArray(newArray);
    }

    public static <T> Set<T> toSet(Collection<T> collection) {
        return SetFactory.newHashSet(collection, new Object[0]);
    }

    public static <T> SortedSet<T> toSortedSet(Collection<T> collection) {
        return SetFactory.newTreeSet(collection, new Object[0]);
    }
}

