/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;

public final class SerializedObjectExtensions {
    private SerializedObjectExtensions() {
    }

    public static Object readSerializedObjectFromFile(File file) throws IOException, ClassNotFoundException {
        Object object;
        try (FileInputStream fis = new FileInputStream(file);
             ObjectInputStream in = new ObjectInputStream(fis);){
            object = in.readObject();
        }
        return object;
    }

    public static <T extends Serializable> byte[] toByteArray(T object) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);){
            byte[] byArray;
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
                objectOutputStream.writeObject(object);
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }

    public static <T extends Serializable> String toBase64EncodedString(T object) throws IOException {
        return Base64.getEncoder().encodeToString(SerializedObjectExtensions.toByteArray(object));
    }

    public static Object toObject(String base64EncodedString) throws IOException, ClassNotFoundException {
        return SerializedObjectExtensions.toObject(Base64.getDecoder().decode(base64EncodedString));
    }

    public static Object toObject(byte[] byteArray) throws IOException, ClassNotFoundException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);){
            Object object;
            try (ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);){
                object = objectInputStream.readObject();
            }
            return object;
        }
    }

    public static boolean writeSerializedObjectToFile(Object obj, File file) throws IOException {
        boolean written = false;
        try (FileOutputStream fos = new FileOutputStream(file);
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(obj);
            oos.flush();
            oos.close();
            written = true;
        }
        return written;
    }
}

