/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.io.annotations;

import io.github.astrapi69.io.annotations.ClassloaderExtensions;
import io.github.astrapi69.io.annotations.FindClassExtensions;
import io.github.astrapi69.io.file.FilenameExtensions;
import io.github.astrapi69.io.file.filter.ClassFileFilter;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class AnnotationExtensions {
    public static Set<Class<?>> getAllAnnotatedClasses(String packagePath, Class<? extends Annotation> annotationClass) throws ClassNotFoundException, IOException, URISyntaxException {
        List<File> directories = FindClassExtensions.getDirectoriesFromResources(packagePath, true);
        HashSet classes = new HashSet();
        for (File directory : directories) {
            classes.addAll(AnnotationExtensions.scanForAnnotatedClasses(directory, packagePath, annotationClass));
        }
        return classes;
    }

    public static Set<Class<?>> getAllAnnotatedClassesFromSet(String packagePath, Set<Class<? extends Annotation>> annotationClasses) throws ClassNotFoundException, IOException, URISyntaxException {
        List<File> directories = FindClassExtensions.getDirectoriesFromResources(packagePath, true);
        HashSet classes = new HashSet();
        for (File directory : directories) {
            classes.addAll(AnnotationExtensions.scanForAnnotatedClassesFromSet(directory, packagePath, annotationClasses));
        }
        return classes;
    }

    public static Set<Class<?>> getAllClasses(String packagePath) throws ClassNotFoundException, IOException, URISyntaxException {
        return AnnotationExtensions.getAllAnnotatedClasses(packagePath, null);
    }

    public static Set<Class<?>> getAllClasses(String packagePath, Set<Class<? extends Annotation>> annotationClasses) throws ClassNotFoundException, IOException, URISyntaxException {
        return AnnotationExtensions.getAllAnnotatedClassesFromSet(packagePath, annotationClasses);
    }

    public static <T extends Annotation> T getAnnotation(Class<?> componentClass, Class<T> annotationClass) {
        Class<?> superClass;
        T annotation = componentClass.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        for (Class<?> ifc : componentClass.getInterfaces()) {
            annotation = AnnotationExtensions.getAnnotation(ifc, annotationClass);
            if (annotation == null) continue;
            return annotation;
        }
        if (!Annotation.class.isAssignableFrom(componentClass)) {
            for (Annotation ann : componentClass.getAnnotations()) {
                annotation = AnnotationExtensions.getAnnotation(ann.annotationType(), annotationClass);
                if (annotation == null) continue;
                return annotation;
            }
        }
        if ((superClass = componentClass.getSuperclass()) == null || superClass.equals(Object.class)) {
            return null;
        }
        return AnnotationExtensions.getAnnotation(superClass, annotationClass);
    }

    public static boolean isAnnotationPresentInSuperClasses(Class<?> componentClass, Class<? extends Annotation> annotationClass) {
        if (componentClass.isAnnotationPresent(annotationClass)) {
            return true;
        }
        for (Class<?> superClass = componentClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (!superClass.isAnnotationPresent(annotationClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotationPresentInSuperClassesOrInterfaces(Class<?> componentClass, Class<? extends Annotation> annotationClass) {
        return AnnotationExtensions.getAnnotation(componentClass, annotationClass) != null;
    }

    public static Set<Class<?>> scanForAnnotatedClasses(File directory, String packagePath, Class<? extends Annotation> annotationClass) throws ClassNotFoundException {
        File[] files;
        HashSet foundClasses = new HashSet();
        if (!directory.exists()) {
            return foundClasses;
        }
        ClassFileFilter includeFileFilter = new ClassFileFilter();
        for (File file : files = directory.listFiles(includeFileFilter)) {
            String qualifiedClassname = null;
            if (file.isDirectory()) {
                qualifiedClassname = packagePath + "." + file.getName();
                foundClasses.addAll(AnnotationExtensions.scanForAnnotatedClasses(file, qualifiedClassname, annotationClass));
                continue;
            }
            String filename = FilenameExtensions.getFilenameWithoutExtension(file);
            qualifiedClassname = packagePath + "." + filename;
            Class<?> foundClass = null;
            try {
                foundClass = FindClassExtensions.forName(qualifiedClassname);
                if (annotationClass != null) {
                    if (!foundClass.isAnnotationPresent(annotationClass)) continue;
                    foundClasses.add(foundClass);
                    continue;
                }
                foundClasses.add(foundClass);
            }
            catch (Throwable throwable) {
                foundClass = Class.forName(qualifiedClassname, false, ClassloaderExtensions.getClassLoader());
                if (annotationClass != null) {
                    if (!foundClass.isAnnotationPresent(annotationClass)) continue;
                    foundClasses.add(foundClass);
                    continue;
                }
                foundClasses.add(foundClass);
            }
        }
        return foundClasses;
    }

    public static Set<Class<?>> scanForAnnotatedClassesFromSet(File directory, String packagePath, Set<Class<? extends Annotation>> annotationClasses) throws ClassNotFoundException {
        File[] files;
        HashSet foundClasses = new HashSet();
        if (!directory.exists()) {
            return foundClasses;
        }
        ClassFileFilter includeFileFilter = new ClassFileFilter();
        for (File file : files = directory.listFiles(includeFileFilter)) {
            String qualifiedClassname = null;
            if (file.isDirectory()) {
                qualifiedClassname = packagePath + "." + file.getName();
                foundClasses.addAll(AnnotationExtensions.scanForAnnotatedClassesFromSet(file, qualifiedClassname, annotationClasses));
                continue;
            }
            String filename = FilenameExtensions.getFilenameWithoutExtension(file);
            qualifiedClassname = packagePath + "." + filename;
            Class<?> foundClass = null;
            try {
                foundClass = Class.forName(qualifiedClassname);
                AnnotationExtensions.resolveAnnotatedClasses(annotationClasses, foundClasses, foundClass);
            }
            catch (Throwable throwable) {
                foundClass = Class.forName(qualifiedClassname, false, ClassloaderExtensions.getClassLoader());
                AnnotationExtensions.resolveAnnotatedClasses(annotationClasses, foundClasses, foundClass);
            }
        }
        return foundClasses;
    }

    private static void resolveAnnotatedClasses(Set<Class<? extends Annotation>> annotationClasses, Set<Class<?>> foundClasses, Class<?> foundClass) {
        if (null != annotationClasses) {
            for (Class<? extends Annotation> annotationClass : annotationClasses) {
                if (!foundClass.isAnnotationPresent(annotationClass)) continue;
                foundClasses.add(foundClass);
            }
        } else {
            foundClasses.add(foundClass);
        }
    }

    public static Set<Class<?>> scanForClasses(File directory, String packagePath) throws ClassNotFoundException {
        return AnnotationExtensions.scanForAnnotatedClasses(directory, packagePath, null);
    }

    public static Object setAnnotationValue(Annotation annotation, String key, Object value) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(annotation);
        Field field = invocationHandler.getClass().getDeclaredField("memberValues");
        field.setAccessible(true);
        Map memberValues = (Map)field.get(invocationHandler);
        Object oldValue = memberValues.get(key);
        if (oldValue == null || oldValue.getClass() != value.getClass()) {
            throw new IllegalArgumentException();
        }
        memberValues.put(key, value);
        return oldValue;
    }
}

