/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.io.annotations;

import io.github.astrapi69.io.annotations.ClassloaderExtensions;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FindClassExtensions {
    public static Class<?> forName(String className) throws ClassNotFoundException {
        Class<?> clazz;
        block2: {
            clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (Throwable throwable) {
                clazz = Class.forName(className, true, ClassloaderExtensions.getClassLoader());
                if (clazz != null || (clazz = Class.forName(className, false, ClassloaderExtensions.getClassLoader())) != null) break block2;
                throw throwable;
            }
        }
        return clazz;
    }

    public static List<File> getDirectoriesFromResources(String path, boolean isPackage) throws IOException, URISyntaxException {
        if (isPackage) {
            path = path.replace('.', '/');
        }
        List<URL> resources = FindClassExtensions.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        for (URL resource : resources) {
            dirs.add(new File(URLDecoder.decode(resource.getFile(), "UTF-8")));
        }
        return dirs;
    }

    public static List<URL> getResources(String path) throws IOException {
        ClassLoader classLoader = ClassloaderExtensions.getClassLoader();
        ArrayList<URL> list = Collections.list(classLoader.getResources(path));
        return list;
    }
}

