/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.io.annotations;

import io.github.astrapi69.io.annotations.AnnotationExtensions;
import io.github.astrapi69.io.annotations.ImportResource;
import io.github.astrapi69.io.annotations.ImportResourceComparator;
import io.github.astrapi69.io.annotations.ImportResources;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class ImportResourcesExtensions {
    public static Map<Class<?>, ImportResource[]> getImportResources(String packageName) throws ClassNotFoundException, IOException, URISyntaxException {
        LinkedHashMap resourcesMap = new LinkedHashMap();
        Class<ImportResources> importResourcesClass = ImportResources.class;
        Class<ImportResource> importResourceClass = ImportResource.class;
        Set<Class<?>> importResourcesClasses = AnnotationExtensions.getAllAnnotatedClasses(packageName, importResourcesClass);
        Set<Class<?>> importResourceClasses = AnnotationExtensions.getAllAnnotatedClasses(packageName, importResourceClass);
        importResourcesClasses.addAll(importResourceClasses);
        for (Class<?> annotatedClass : importResourcesClasses) {
            ImportResource importResource;
            ImportResources importResources = annotatedClass.getAnnotation(ImportResources.class);
            ImportResource[] importResourcesArray = null;
            ImportResource[] importResourceArray = null;
            if (importResources != null) {
                importResourcesArray = importResources.resources();
            }
            if ((importResource = annotatedClass.getAnnotation(ImportResource.class)) != null) {
                importResourceArray = new ImportResource[]{importResource};
            }
            ImportResource[] array = ImportResourcesExtensions.join(importResourceArray, importResourcesArray);
            Arrays.sort(array, new ImportResourceComparator());
            resourcesMap.put(annotatedClass, array);
        }
        return resourcesMap;
    }

    public static <T> T[] join(T[] array1, T ... array2) {
        if (array1 == null) {
            return array2;
        }
        if (array2 == null) {
            return array1;
        }
        Class<?> type1 = array1.getClass().getComponentType();
        Object[] joinedArray = (Object[])Array.newInstance(type1, array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        try {
            System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        }
        catch (ArrayStoreException ase) {
            Class<?> type2 = array2.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                throw new IllegalArgumentException("Cannot store " + type2.getName() + " in an array of " + type1.getName(), ase);
            }
            throw ase;
        }
        return joinedArray;
    }
}

