/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.io.annotations;

import io.github.astrapi69.io.annotations.FindClassExtensions;
import io.github.astrapi69.io.annotations.ScanPackageExtensions;
import io.github.astrapi69.io.file.FileExtension;
import io.github.astrapi69.io.file.FilenameExtensions;
import io.github.astrapi69.io.file.filter.ClassFileFilter;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;

public final class ScanClassExtensions {
    public static boolean equalsByClassName(Class<?> oneClass, Class<?> otherClass) {
        String oneNormalizedClassName = ScanClassExtensions.normalizeQualifiedClassName(oneClass.getName());
        String otherNormalizedClassName = ScanClassExtensions.normalizeQualifiedClassName(otherClass.getName());
        return otherNormalizedClassName.equals(oneNormalizedClassName);
    }

    public static String normalizeQualifiedClassName(String qualifiedClassname) {
        return ScanClassExtensions.normalizeSimpleClassName(qualifiedClassname).replaceAll("/", ".");
    }

    public static String normalizeSimpleClassName(String className) {
        int lastIndexOf$;
        String result = className;
        if (className.endsWith(FileExtension.CLASS.getExtension())) {
            result = ScanClassExtensions.replaceLast(className, FileExtension.CLASS.getExtension(), "");
        }
        if ((lastIndexOf$ = result.lastIndexOf("$")) != -1) {
            String prefix = result.substring(0, lastIndexOf$);
            String compilerClassName = result.substring(lastIndexOf$ + 1, result.length());
            if (ScanClassExtensions.isNumeric(compilerClassName)) {
                return prefix;
            }
        }
        return result;
    }

    private static final String replaceLast(String original, String findString, String replacement) {
        int index = original.lastIndexOf(findString);
        if (index == -1) {
            return original;
        }
        StringBuffer originalFiltered = new StringBuffer();
        originalFiltered.append(original.substring(0, index));
        originalFiltered.append(replacement);
        originalFiltered.append(original.substring(index + findString.length()));
        String result = originalFiltered.toString().trim();
        return result;
    }

    private static boolean isNumeric(CharSequence cs) {
        if (cs == null || cs.length() == 0) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Set<Class<?>> scanClassesFromPackage(File directory, String packagePath) throws ClassNotFoundException {
        return ScanClassExtensions.scanClassesFromPackage(directory, packagePath, false);
    }

    public static Set<Class<?>> scanClassesFromPackage(File directory, String packagePath, boolean recursive) throws ClassNotFoundException {
        File[] files;
        LinkedHashSet foundClasses = new LinkedHashSet();
        if (!directory.exists()) {
            return foundClasses;
        }
        ClassFileFilter includeFileFilter = new ClassFileFilter();
        for (File file : files = directory.listFiles(includeFileFilter)) {
            String qualifiedClassname = null;
            if (file.isDirectory() && recursive) {
                qualifiedClassname = packagePath + "." + file.getName();
                foundClasses.addAll(ScanClassExtensions.scanClassesFromPackage(file, qualifiedClassname, recursive));
                continue;
            }
            if (file.isDirectory()) continue;
            String filename = FilenameExtensions.getFilenameWithoutExtension(file);
            qualifiedClassname = packagePath + "." + filename;
            foundClasses.add(FindClassExtensions.forName(qualifiedClassname));
        }
        return foundClasses;
    }

    public static Set<Class<?>> scanClassNames(String packageName) throws IOException, ClassNotFoundException {
        return ScanClassExtensions.scanClassNames(packageName, false);
    }

    public static Set<Class<?>> scanClassNames(String packageName, boolean recursive) throws IOException, ClassNotFoundException {
        LinkedHashSet foundClasses = new LinkedHashSet();
        Set<String> qualifiedClassnames = ScanPackageExtensions.scanClassNames(packageName, recursive, true);
        for (String qualifiedClassname : qualifiedClassnames) {
            foundClasses.add(FindClassExtensions.forName(qualifiedClassname));
        }
        return foundClasses;
    }
}

