/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.io.annotations;

import io.github.astrapi69.io.annotations.ClassloaderExtensions;
import io.github.astrapi69.io.file.FilenameExtensions;
import io.github.astrapi69.io.file.filter.ClassFileFilter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class ScanPackageExtensions {
    public static Set<String> scanClassNames(String packageName) throws IOException {
        return ScanPackageExtensions.scanClassNames(packageName, false, true);
    }

    public static Set<String> scanClassNames(String packageName, boolean recursive, boolean qualifiedClassnames) throws IOException {
        ClassLoader classLoader = ClassloaderExtensions.getClassLoader();
        LinkedHashSet<String> classNames = new LinkedHashSet<String>();
        String packagePath = packageName.replace(".", "/");
        URL packageURL = classLoader.getResource(packagePath);
        if (packageURL == null) {
            return classNames;
        }
        if (packageURL.getProtocol().equals("jar") || packageURL.getProtocol().equals("ear") || packageURL.getProtocol().equals("war")) {
            String fileName = URLDecoder.decode(packageURL.getFile(), "UTF-8");
            fileName = fileName.substring(5, fileName.indexOf("!"));
            JarFile jarFile = new JarFile(fileName);
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                String relativePath;
                JarEntry entry = jarEntries.nextElement();
                boolean isDir = entry.isDirectory();
                String entryName = entry.getName();
                if (isDir && recursive) {
                    String entryPath = entryName.replace("/", ".");
                    if (ScanPackageExtensions.lastCharacter(entryPath).equals(".")) {
                        entryPath = entryPath.substring(0, entryPath.length() - 1);
                    }
                    if (!entryPath.startsWith(packageName) || packageName.length() >= entryPath.length()) continue;
                    classNames.addAll(ScanPackageExtensions.scanClassNames(entryPath, recursive, qualifiedClassnames));
                    continue;
                }
                if (isDir || !entryName.startsWith(packagePath) || (relativePath = entryName.substring(packagePath.length() + 1, entryName.length())).contains("/") || relativePath.contains("$")) continue;
                String filenameWithoutExtension = FilenameExtensions.getFilenameWithoutExtension(entryName.replace("/", "."));
                if (qualifiedClassnames) {
                    classNames.add(filenameWithoutExtension);
                    continue;
                }
                String className = FilenameExtensions.getFilenameWithoutExtension(relativePath);
                classNames.add(className);
            }
            jarFile.close();
        } else {
            File[] files;
            String folderName = URLDecoder.decode(packageURL.getFile(), "UTF-8");
            File folder = new File(folderName);
            ClassFileFilter includeFileFilter = new ClassFileFilter();
            for (File file : files = folder.listFiles(includeFileFilter)) {
                String qualifiedClassname = null;
                if (file.isDirectory() && recursive) {
                    qualifiedClassname = packagePath + "." + file.getName();
                    classNames.addAll(ScanPackageExtensions.scanClassNames(qualifiedClassname, recursive, qualifiedClassnames));
                    continue;
                }
                if (file.isDirectory()) continue;
                String filenameWithoutExtension = FilenameExtensions.getFilenameWithoutExtension(file);
                if (qualifiedClassnames) {
                    qualifiedClassname = packageName + "." + filenameWithoutExtension;
                    classNames.add(qualifiedClassname.replace("/", "."));
                    continue;
                }
                classNames.add(filenameWithoutExtension);
            }
        }
        return classNames;
    }

    private static String lastCharacter(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        return str.substring(str.length() - 1);
    }
}

